/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema.impl;

import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.SQLParseEngine;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class TransparentSchema
extends LogicSchema {
    private final ShardingSphereMetaData metaData;
    private final ShardingRule shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());

    public TransparentSchema(String name, Map<String, YamlDataSourceParameter> dataSources) throws SQLException {
        super(name, dataSources);
        this.metaData = this.createMetaData();
    }

    @Override
    public SQLParseEngine getParseEngine() {
        return null;
    }

    private ShardingSphereMetaData createMetaData() throws SQLException {
        DataSourceMetas dataSourceMetas = new DataSourceMetas(this.getDataSourceURLs(this.getDataSources()), LogicSchemas.getInstance().getDatabaseType());
        TableMetas tableMetas = new TableMetas(this.getTableMetaDataInitializer(dataSourceMetas).load(this.shardingRule));
        return new ShardingSphereMetaData(dataSourceMetas, tableMetas);
    }

    @Override
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }
}

