/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain.ShardingCTLExplainStatement;

public final class ShardingCTLExplainParser
implements ShardingCTLParser<ShardingCTLExplainStatement> {
    private final String regex = "sctl:explain\\s+([\\s\\S]*)";
    private final Matcher matcher;

    ShardingCTLExplainParser(String sql) {
        this.matcher = Pattern.compile("sctl:explain\\s+([\\s\\S]*)", 2).matcher(sql);
    }

    @Override
    public Optional<ShardingCTLExplainStatement> doParse() {
        if (this.matcher.find()) {
            String value = this.matcher.group(1);
            Preconditions.checkNotNull((Object)value, (Object)"sctl explain sql cannot be null.");
            return Optional.of((Object)new ShardingCTLExplainStatement(value));
        }
        return Optional.absent();
    }
}

