/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint;

import com.google.common.base.Optional;
import java.sql.SQLException;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.InvalidShardingCTLFormatException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.ShardingCTLHintParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.ShardingCTLHintStatement;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommand;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommandExecutor;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.hint.internal.HintCommandExecutorFactory;

public final class ShardingCTLHintBackendHandler
implements TextProtocolBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;
    private HintCommandExecutor hintCommandExecutor;

    public ShardingCTLHintBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql;
        this.backendConnection = backendConnection;
    }

    @Override
    public BackendResponse execute() {
        if (!this.backendConnection.isSupportHint()) {
            throw new UnsupportedOperationException(String.format("%s should be true, please check your config", ShardingPropertiesConstant.PROXY_HINT_ENABLED.getKey()));
        }
        Optional<ShardingCTLHintStatement> shardingTCLStatement = new ShardingCTLHintParser(this.sql).doParse();
        if (!shardingTCLStatement.isPresent()) {
            return new ErrorResponse(new InvalidShardingCTLFormatException(this.sql));
        }
        HintCommand hintCommand = ((ShardingCTLHintStatement)shardingTCLStatement.get()).getHintCommand();
        this.hintCommandExecutor = HintCommandExecutorFactory.newInstance(hintCommand, this.backendConnection, this.sql);
        return this.hintCommandExecutor.execute(hintCommand);
    }

    @Override
    public boolean next() throws SQLException {
        return this.hintCommandExecutor.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        return this.hintCommandExecutor.getQueryData();
    }
}

