/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.set;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.set.ShardingCTLSetStatement;

public final class ShardingCTLSetParser
implements ShardingCTLParser<ShardingCTLSetStatement> {
    private final String regex = "sctl:set\\s+(\\S*)=(\\S*)";
    private final Matcher matcher;

    ShardingCTLSetParser(String sql) {
        this.matcher = Pattern.compile("sctl:set\\s+(\\S*)=(\\S*)", 2).matcher(sql);
    }

    @Override
    public Optional<ShardingCTLSetStatement> doParse() {
        if (this.matcher.find()) {
            String key = this.matcher.group(1);
            String value = this.matcher.group(2);
            Preconditions.checkNotNull((Object)key, (Object)"sctl key cannot be null.");
            Preconditions.checkNotNull((Object)value, (Object)"sctl value cannot be null.");
            return Optional.of((Object)new ShardingCTLSetStatement(key, value));
        }
        return Optional.absent();
    }
}

