/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.datasource;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetter;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.core.env.Environment;

public final class HikariDataSourcePropertiesSetter
implements DataSourcePropertiesSetter {
    @Override
    public void propertiesSet(Environment environment, String prefix, String dataSourceName, DataSource dataSource) {
        Properties properties = new Properties();
        String datasourcePropertiesKey = prefix + dataSourceName.trim() + ".data-source-properties";
        if (PropertyUtil.containPropertyPrefix(environment, datasourcePropertiesKey)) {
            Map datasourceProperties = PropertyUtil.handle(environment, datasourcePropertiesKey, Map.class);
            properties.putAll((Map<?, ?>)datasourceProperties);
            Method method = dataSource.getClass().getMethod("setDataSourceProperties", Properties.class);
            method.invoke((Object)dataSource, properties);
        }
    }

    @Override
    public String getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }
}

