/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.narayana.manager;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.shardingsphere.transaction.xa.narayana.manager.DataSourceXAResourceRecoveryHelper;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManager;

public final class NarayanaXATransactionManager
implements XATransactionManager {
    private static final TransactionManager TRANSACTION_MANAGER = jtaPropertyManager.getJTAEnvironmentBean().getTransactionManager();
    private static final XARecoveryModule XA_RECOVERY_MODULE = XARecoveryModule.getRegisteredXARecoveryModule();
    private static final RecoveryManagerService RECOVERY_MANAGER_SERVICE = new RecoveryManagerService();

    public void init() {
        RecoveryManager.delayRecoveryManagerThread();
        RECOVERY_MANAGER_SERVICE.create();
        RECOVERY_MANAGER_SERVICE.start();
    }

    public void registerRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        XA_RECOVERY_MODULE.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
    }

    public void removeRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        XA_RECOVERY_MODULE.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
    }

    public void enlistResource(SingleXAResource singleXAResource) {
        TRANSACTION_MANAGER.getTransaction().enlistResource(singleXAResource.getDelegate());
    }

    public TransactionManager getTransactionManager() {
        return TRANSACTION_MANAGER;
    }

    public void close() throws Exception {
        RECOVERY_MANAGER_SERVICE.stop();
        RECOVERY_MANAGER_SERVICE.destroy();
    }
}

