/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.distsql.statement.ShowAuthorityRuleStatement;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ShowAuthorityRuleExecutor
implements DistSQLQueryExecutor<ShowAuthorityRuleStatement>,
DistSQLExecutorRuleAware<AuthorityRule> {
    private AuthorityRule rule;

    public Collection<String> getColumnNames(ShowAuthorityRuleStatement sqlStatement) {
        return Arrays.asList("users", "provider", "props");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowAuthorityRuleStatement sqlStatement, ContextManager contextManager) {
        String users = this.rule.getConfiguration().getUsers().stream().map(each -> each.getGrantee().toString()).collect(Collectors.joining("; "));
        String provider = this.rule.getConfiguration().getPrivilegeProvider().getType();
        Properties props = this.rule.getConfiguration().getPrivilegeProvider().getProps().isEmpty() ? new Properties() : this.rule.getConfiguration().getPrivilegeProvider().getProps();
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{users, provider, props}));
    }

    public Class<AuthorityRule> getRuleClass() {
        return AuthorityRule.class;
    }

    public Class<ShowAuthorityRuleStatement> getType() {
        return ShowAuthorityRuleStatement.class;
    }

    @Generated
    public void setRule(AuthorityRule rule) {
        this.rule = rule;
    }
}

