/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.broadcast.distsql.handler.update;

import com.cedarsoftware.util.CaseInsensitiveSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.broadcast.api.config.BroadcastRuleConfiguration;
import org.apache.shardingsphere.broadcast.distsql.statement.DropBroadcastTableRuleStatement;
import org.apache.shardingsphere.broadcast.rule.BroadcastRule;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

@DistSQLExecutorCurrentRuleRequired(value=BroadcastRule.class)
public final class DropBroadcastTableRuleExecutor
implements DatabaseRuleDropExecutor<DropBroadcastTableRuleStatement, BroadcastRule, BroadcastRuleConfiguration> {
    private ShardingSphereDatabase database;
    private BroadcastRule rule;

    public void checkBeforeUpdate(DropBroadcastTableRuleStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkBroadcastTableRuleExist(sqlStatement);
        }
    }

    private void checkBroadcastTableRuleExist(DropBroadcastTableRuleStatement sqlStatement) {
        CaseInsensitiveSet currentRules = new CaseInsensitiveSet(this.rule.getConfiguration().getTables());
        Collection notExistedRules = sqlStatement.getTables().stream().filter(arg_0 -> DropBroadcastTableRuleExecutor.lambda$checkBroadcastTableRuleExist$0((Collection)currentRules, arg_0)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedRules.isEmpty(), () -> new MissingRequiredRuleException("Broadcast", this.database.getName(), notExistedRules));
    }

    public boolean hasAnyOneToBeDropped(DropBroadcastTableRuleStatement sqlStatement) {
        return !Collections.disjoint(this.rule.getConfiguration().getTables(), sqlStatement.getTables());
    }

    public BroadcastRuleConfiguration buildToBeAlteredRuleConfiguration(DropBroadcastTableRuleStatement sqlStatement) {
        BroadcastRuleConfiguration result = new BroadcastRuleConfiguration(new HashSet(this.rule.getConfiguration().getTables()));
        CaseInsensitiveSet toBeDroppedTableNames = new CaseInsensitiveSet(sqlStatement.getTables());
        result.getTables().removeIf(((Collection)toBeDroppedTableNames)::contains);
        return result;
    }

    public Class<BroadcastRule> getRuleClass() {
        return BroadcastRule.class;
    }

    public Class<DropBroadcastTableRuleStatement> getType() {
        return DropBroadcastTableRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(BroadcastRule rule) {
        this.rule = rule;
    }

    private static /* synthetic */ boolean lambda$checkBroadcastTableRuleExist$0(Collection currentRules, String each) {
        return !currentRules.contains(each);
    }
}

