/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.InstanceContextAware;
import org.apache.shardingsphere.infra.util.props.TypedProperties;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.exception.ClusterPersistRepositoryException;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.apache.shardingsphere.mode.repository.cluster.lock.holder.DistributedLockHolder;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.ZookeeperExceptionHandler;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener.SessionConnectionListener;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperProperties;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperPropertyKey;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class ZookeeperRepository
implements ClusterPersistRepository,
InstanceContextAware {
    private final Map<String, CuratorCache> caches = new ConcurrentHashMap<String, CuratorCache>();
    private final CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
    private CuratorFramework client;
    private DistributedLockHolder distributedLockHolder;

    public void init(ClusterPersistRepositoryConfiguration config) {
        ZookeeperProperties zookeeperProps = new ZookeeperProperties(config.getProps());
        this.client = this.buildCuratorClient(config, zookeeperProps);
        this.distributedLockHolder = new DistributedLockHolder(this.getType(), (Object)this.client, (TypedProperties)zookeeperProps);
        this.initCuratorClient(zookeeperProps);
    }

    private CuratorFramework buildCuratorClient(ClusterPersistRepositoryConfiguration config, ZookeeperProperties zookeeperProps) {
        String digest;
        int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
        int timeToLiveSeconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        int operationTimeoutMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS);
        this.builder.connectString(config.getServerLists()).ensembleTracker(false).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries)).namespace(config.getNamespace());
        if (0 != timeToLiveSeconds) {
            this.builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            this.builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)(digest = (String)zookeeperProps.getValue(ZookeeperPropertyKey.DIGEST)))) {
            this.builder.authorization(ZookeeperPropertyKey.DIGEST.getKey(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return this.builder.build();
    }

    private void initCuratorClient(ZookeeperProperties zookeeperProps) {
        this.client.start();
        try {
            int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
            int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (KeeperException.OperationTimeoutException ex) {
            ZookeeperExceptionHandler.handleException((Exception)((Object)ex));
        }
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void persist(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.update(key, value);
            } else {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void update(String key, String value) {
        try {
            this.client.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }

    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void persistExclusiveEphemeral(String key, String value) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (KeeperException.NodeExistsException ex) {
            throw new ClusterPersistRepositoryException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void delete(String key) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void watch(String key, DataChangedEventListener listener) {
        CuratorCache cache = this.caches.get(key);
        if (null == cache) {
            cache = CuratorCache.build((CuratorFramework)this.client, (String)key, (CuratorCache.Options[])new CuratorCache.Options[0]);
            this.caches.put(key, cache);
        }
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().afterInitialized().forTreeCache(this.client, (framework, treeCacheListener) -> {
            DataChangedEvent.Type changedType = this.getChangedType(treeCacheListener.getType());
            if (DataChangedEvent.Type.IGNORED != changedType) {
                listener.onChange(new DataChangedEvent(treeCacheListener.getData().getPath(), new String(treeCacheListener.getData().getData(), StandardCharsets.UTF_8), changedType));
            }
        }).build();
        cache.listenable().addListener((Object)curatorCacheListener);
        cache.start();
    }

    private DataChangedEvent.Type getChangedType(TreeCacheEvent.Type type) {
        switch (type) {
            case NODE_ADDED: {
                return DataChangedEvent.Type.ADDED;
            }
            case NODE_UPDATED: {
                return DataChangedEvent.Type.UPDATED;
            }
            case NODE_REMOVED: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    public void close() {
        this.caches.values().forEach(CuratorCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.client.getConnectionStateListenable().addListener((Object)new SessionConnectionListener(instanceContext, this));
    }

    public String getType() {
        return "ZooKeeper";
    }

    @Generated
    public DistributedLockHolder getDistributedLockHolder() {
        return this.distributedLockHolder;
    }
}

