/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.lock;

import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.ZookeeperExceptionHandler;

public final class ZookeeperDistributedLock
implements DistributedLock {
    private final InterProcessLock lock;

    public ZookeeperDistributedLock(String lockKey, CuratorFramework client) {
        this.lock = new InterProcessMutex(client, lockKey);
    }

    public boolean tryLock(long timeoutMillis) {
        try {
            return this.lock.acquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void unlock() {
        try {
            this.lock.release();
        }
        catch (Exception ex) {
            ZookeeperExceptionHandler.handleException(ex);
        }
    }
}

