/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener;

import java.util.Properties;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionConnectionListener
implements ConnectionStateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionConnectionListener.class);
    private static final int RECONNECT_INTERVAL_SECONDS = 5;
    private final InstanceContext instanceContext;
    private final ClusterPersistRepository repository;

    public void stateChanged(CuratorFramework client, ConnectionState connectionState) {
        if (ConnectionState.LOST == connectionState) {
            boolean reRegistered;
            while (!(reRegistered = this.reRegister(client))) {
            }
            log.debug("Instance re-register success instance id: {}", (Object)this.instanceContext.getInstance().getCurrentInstanceId());
        }
    }

    private boolean reRegister(CuratorFramework client) {
        try {
            if (client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                if (this.isNeedGenerateWorkerId()) {
                    this.instanceContext.generateWorkerId(new Properties());
                }
                this.reRegisterInstanceComputeNode();
                return true;
            }
            this.sleepInterval();
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    private boolean isNeedGenerateWorkerId() {
        return -1 != this.instanceContext.getInstance().getWorkerId();
    }

    private void reRegisterInstanceComputeNode() {
        ComputeNodeInstance instance = this.instanceContext.getInstance();
        this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)instance.getCurrentInstanceId(), (InstanceType)instance.getMetaData().getType()), YamlEngine.marshal((Object)new ComputeNodeData(instance.getMetaData().getAttributes(), instance.getMetaData().getVersion())));
        this.repository.persistEphemeral(ComputeNode.getInstanceLabelsNodePath((String)instance.getCurrentInstanceId()), YamlEngine.marshal((Object)instance.getLabels()));
        this.repository.persistEphemeral(ComputeNode.getInstanceStatusNodePath((String)instance.getCurrentInstanceId()), instance.getState().getCurrentState().name());
    }

    private void sleepInterval() {
        Thread.sleep(5000L);
    }

    @Generated
    public SessionConnectionListener(InstanceContext instanceContext, ClusterPersistRepository repository) {
        this.instanceContext = instanceContext;
        this.repository = repository;
    }
}

