/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.ingest;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.DumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;

public final class InventoryDumperConfiguration
extends DumperConfiguration {
    private String actualTableName;
    private String logicTableName;
    private List<PipelineColumnMetaData> uniqueKeyColumns;
    private Integer shardingItem;
    private int batchSize = 1000;
    private JobRateLimitAlgorithm rateLimitAlgorithm;

    public InventoryDumperConfiguration(DumperConfiguration dumperConfig) {
        this.setDataSourceName(dumperConfig.getDataSourceName());
        this.setDataSourceConfig(dumperConfig.getDataSourceConfig());
        this.setTableNameMap(dumperConfig.getTableNameMap());
        this.setTableNameSchemaNameMapping(dumperConfig.getTableNameSchemaNameMapping());
        this.setTargetTableColumnsMap(dumperConfig.getTargetTableColumnsMap());
    }

    public boolean hasUniqueKey() {
        return null != this.uniqueKeyColumns && this.uniqueKeyColumns.size() > 0;
    }

    @Generated
    public String getActualTableName() {
        return this.actualTableName;
    }

    @Generated
    public String getLogicTableName() {
        return this.logicTableName;
    }

    @Generated
    public List<PipelineColumnMetaData> getUniqueKeyColumns() {
        return this.uniqueKeyColumns;
    }

    @Generated
    public Integer getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public void setActualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    @Generated
    public void setLogicTableName(String logicTableName) {
        this.logicTableName = logicTableName;
    }

    @Generated
    public void setUniqueKeyColumns(List<PipelineColumnMetaData> uniqueKeyColumns) {
        this.uniqueKeyColumns = uniqueKeyColumns;
    }

    @Generated
    public void setShardingItem(Integer shardingItem) {
        this.shardingItem = shardingItem;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setRateLimitAlgorithm(JobRateLimitAlgorithm rateLimitAlgorithm) {
        this.rateLimitAlgorithm = rateLimitAlgorithm;
    }

    @Override
    @Generated
    public String toString() {
        return "InventoryDumperConfiguration(super=" + super.toString() + ", actualTableName=" + this.getActualTableName() + ", logicTableName=" + this.getLogicTableName() + ", uniqueKeyColumns=" + this.getUniqueKeyColumns() + ", shardingItem=" + this.getShardingItem() + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ")";
    }
}

