/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.client.util;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.util.JsonFormat;
import java.sql.Timestamp;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtobufAnyValueConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtobufAnyValueConverter.class);

    public static Object convertToObject(Any any) throws InvalidProtocolBufferException {
        if (null == any || any.is(Empty.class)) {
            return null;
        }
        if (any.is(StringValue.class)) {
            return ((StringValue)any.unpack(StringValue.class)).getValue();
        }
        if (any.is(Int32Value.class)) {
            return ((Int32Value)any.unpack(Int32Value.class)).getValue();
        }
        if (any.is(Int64Value.class)) {
            return ((Int64Value)any.unpack(Int64Value.class)).getValue();
        }
        if (any.is(Int64Value.class)) {
            return ((Int64Value)any.unpack(Int64Value.class)).getValue();
        }
        if (any.is(UInt32Value.class)) {
            return ((UInt64Value)any.unpack(UInt64Value.class)).getValue();
        }
        if (any.is(UInt64Value.class)) {
            return ((UInt64Value)any.unpack(UInt64Value.class)).getValue();
        }
        if (any.is(FloatValue.class)) {
            return Float.valueOf(((FloatValue)any.unpack(FloatValue.class)).getValue());
        }
        if (any.is(DoubleValue.class)) {
            return ((DoubleValue)any.unpack(DoubleValue.class)).getValue();
        }
        if (any.is(BoolValue.class)) {
            return ((BoolValue)any.unpack(BoolValue.class)).getValue();
        }
        if (any.is(BytesValue.class)) {
            return ((BytesValue)any.unpack(BytesValue.class)).getValue().toByteArray();
        }
        if (any.is(com.google.protobuf.Timestamp.class)) {
            return ProtobufAnyValueConverter.converProtobufTimestamp((com.google.protobuf.Timestamp)any.unpack(com.google.protobuf.Timestamp.class));
        }
        if (any.is(Struct.class)) {
            return JsonFormat.printer().print((MessageOrBuilder)any.unpack(Struct.class));
        }
        log.error("not support unpack value={}", (Object)any);
        throw new UnsupportedOperationException(String.format("not support unpack the type %s", any.getTypeUrl()));
    }

    private static Timestamp converProtobufTimestamp(com.google.protobuf.Timestamp timestamp) {
        Timestamp result = new Timestamp(timestamp.getSeconds() * 1000L);
        result.setNanos(timestamp.getNanos());
        return result;
    }

    @Generated
    private ProtobufAnyValueConverter() {
    }
}

