/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.cdc.client.util;

import com.google.common.base.Strings;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.cdc.client.context.ClientConnectionContext;
import org.apache.shardingsphere.data.pipeline.cdc.client.exception.GetResultTimeoutException;
import org.apache.shardingsphere.data.pipeline.cdc.client.exception.ServerResultException;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.request.CDCRequest;
import org.apache.shardingsphere.data.pipeline.cdc.protocol.response.CDCResponse;

public final class ResponseFuture {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final String requestId;
    private final CDCRequest.Type requestType;
    private CDCResponse.Status status;
    private String errorCode;
    private String errorMessage;
    private Object result;

    public Object waitResponseResult(long timeoutMillis, ClientConnectionContext connectionContext) {
        if (!this.countDownLatch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            connectionContext.getResponseFutureMap().remove(this.requestId);
            throw new GetResultTimeoutException("Get result timeout");
        }
        connectionContext.getResponseFutureMap().remove(this.requestId);
        if (!Strings.isNullOrEmpty((String)this.errorMessage)) {
            throw new ServerResultException(String.format("Get %s response failed, code:%s, reason: %s", this.requestType.name(), this.errorCode, this.errorMessage));
        }
        return this.result;
    }

    public void countDown() {
        this.countDownLatch.countDown();
    }

    @Generated
    public ResponseFuture(String requestId, CDCRequest.Type requestType) {
        this.requestId = requestId;
        this.requestType = requestType;
    }

    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    @Generated
    public CDCRequest.Type getRequestType() {
        return this.requestType;
    }

    @Generated
    public CDCResponse.Status getStatus() {
        return this.status;
    }

    @Generated
    public String getErrorCode() {
        return this.errorCode;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Object getResult() {
        return this.result;
    }

    @Generated
    public void setStatus(CDCResponse.Status status) {
        this.status = status;
    }

    @Generated
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setResult(Object result) {
        this.result = result;
    }

    @Generated
    private CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

