/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ddlgenerator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.postgresql.ddlgenerator.AbstractPostgreSQLDDLAdapter;
import org.apache.shardingsphere.data.pipeline.postgresql.util.PostgreSQLPipelineFreemarkerManager;
import org.postgresql.jdbc.PgArray;

public final class PostgreSQLIndexSQLGenerator
extends AbstractPostgreSQLDDLAdapter {
    private static final Integer PG_INDEX_INCLUDE_VERSION = 11;

    public PostgreSQLIndexSQLGenerator(Connection connection, int majorVersion, int minorVersion) {
        super(connection, majorVersion, minorVersion);
    }

    public String generate(Map<String, Object> context) throws SQLException {
        StringBuilder result = new StringBuilder();
        Collection<Map<String, Object>> indexNodes = this.getIndexNodes(context);
        for (Map<String, Object> each : indexNodes) {
            if (each.containsKey("is_inherited") && ((Boolean)each.get("is_inherited")).booleanValue()) continue;
            result.append(this.getIndexSql(context, each));
        }
        return result.toString().trim();
    }

    private Collection<Map<String, Object>> getIndexNodes(Map<String, Object> context) {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        param.put("tid", context.get("tid"));
        return this.executeByTemplate(param, "component/indexes/%s/nodes.ftl");
    }

    private String getIndexSql(Map<String, Object> context, Map<String, Object> indexNode) throws SQLException {
        Map<String, Object> indexData = this.getIndexData(context, indexNode);
        this.appendColumnDetails(indexData, (Long)indexNode.get("oid"));
        if (this.getMajorVersion() >= PG_INDEX_INCLUDE_VERSION) {
            this.appendIncludeDetails(indexData, (Long)indexNode.get("oid"));
        }
        return this.doGenerateIndexSql(indexData);
    }

    private String doGenerateIndexSql(Map<String, Object> indexData) {
        String result = PostgreSQLPipelineFreemarkerManager.getSQLByVersion(indexData, "component/indexes/%s/create.ftl", this.getMajorVersion(), this.getMinorVersion());
        result = result + System.lineSeparator();
        result = result + PostgreSQLPipelineFreemarkerManager.getSQLByVersion(indexData, "component/indexes/%s/alter.ftl", this.getMajorVersion(), this.getMinorVersion());
        return result;
    }

    private Map<String, Object> getIndexData(Map<String, Object> context, Map<String, Object> indexNode) {
        Collection<Map<String, Object>> indexProps = this.fetchIndexProperties(context, indexNode);
        Map<String, Object> result = indexProps.iterator().next();
        result.put("schema", context.get("schema"));
        result.put("table", context.get("name"));
        return result;
    }

    private Collection<Map<String, Object>> fetchIndexProperties(Map<String, Object> context, Map<String, Object> indexNode) {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        param.put("did", context.get("did"));
        param.put("tid", context.get("tid"));
        param.put("idx", indexNode.get("oid"));
        param.put("datlastsysoid", context.get("datlastsysoid"));
        return this.executeByTemplate(param, "component/indexes/%s/properties.ftl");
    }

    private void appendColumnDetails(Map<String, Object> indexData, Long indexId) throws SQLException {
        Collection<Map<String, Object>> columnDetails = this.fetchColumnDetails(indexId);
        LinkedList<Map<String, Object>> columns = new LinkedList<Map<String, Object>>();
        LinkedList<String> columnDisplays = new LinkedList<String>();
        for (Map<String, Object> each : columnDetails) {
            columns.add(this.getColumnData(indexData, each));
            columnDisplays.add(this.getColumnPropertyDisplayData(each, indexData));
        }
        indexData.put("columns", columns);
        indexData.put("columns_csv", String.join((CharSequence)", ", columnDisplays));
    }

    private Map<String, Object> getColumnData(Map<String, Object> indexData, Map<String, Object> columnDetail) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("colname", columnDetail.get("attdef"));
        result.put("collspcname", columnDetail.get("collnspname"));
        result.put("op_class", columnDetail.get("opcname"));
        if ("btree".equals(indexData.get("amname"))) {
            result.put("sort_order", this.isSortOrder(columnDetail));
            result.put("nulls", this.isNulls(columnDetail));
        }
        return result;
    }

    private boolean isSortOrder(Map<String, Object> columnDetail) throws SQLException {
        if (null == columnDetail.get("options")) {
            return false;
        }
        String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
        return options.length > 0 && "DESC".equals(options[0]);
    }

    private Object isNulls(Map<String, Object> columnDetail) throws SQLException {
        if (null == columnDetail.get("options")) {
            return false;
        }
        String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
        return options.length > 1 && options[1].split(" ").length > 1 && "FIRST".equals(options[1].split(" ")[1]);
    }

    private Collection<Map<String, Object>> fetchColumnDetails(Long indexId) {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        param.put("idx", indexId);
        return this.executeByTemplate(param, "component/indexes/%s/column_details.ftl");
    }

    private String getColumnPropertyDisplayData(Map<String, Object> columnDetail, Map<String, Object> indexData) throws SQLException {
        String result = (String)columnDetail.get("attdef");
        if (null != columnDetail.get("collnspname")) {
            result = result + " COLLATE " + columnDetail.get("collnspname");
        }
        if (null != columnDetail.get("opcname")) {
            result = result + " " + columnDetail.get("opcname");
        }
        if ("btree".equals(indexData.get("amname"))) {
            String[] options = (String[])((PgArray)columnDetail.get("options")).getArray();
            if (options.length > 0) {
                result = result + " " + options[0];
            }
            if (options.length > 1) {
                result = result + " " + options[1];
            }
        }
        return result;
    }

    private void appendIncludeDetails(Map<String, Object> indexData, Long oid) {
        LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
        param.put("idx", oid);
        LinkedList<Object> includes = new LinkedList<Object>();
        for (Map<String, Object> each : this.executeByTemplate(param, "component/indexes/%s/include_details.ftl")) {
            includes.add(each.get("colname"));
        }
        indexData.put("include", includes);
    }
}

