/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIngestPositionManager;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.PostgreSQLLogSequenceNumber;
import org.postgresql.replication.LogSequenceNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostgreSQLIngestPositionManager
implements DialectIngestPositionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreSQLIngestPositionManager.class);
    private static final String SLOT_NAME_PREFIX = "pipeline";
    private static final String DECODE_PLUGIN = "test_decoding";
    private static final String DUPLICATE_OBJECT_ERROR_CODE = "42710";

    public WALPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.createSlotIfNotExist(connection, PostgreSQLIngestPositionManager.getUniqueSlotName(connection, slotNameSuffix));
            WALPosition wALPosition = this.getWalPosition(connection);
            return wALPosition;
        }
    }

    public WALPosition init(String data) {
        return new WALPosition(new PostgreSQLLogSequenceNumber(LogSequenceNumber.valueOf((String)data)));
    }

    private void createSlotIfNotExist(Connection connection, String slotName) throws SQLException {
        block9: {
            if (this.isSlotExisting(connection, slotName)) {
                log.info("createSlotIfNotExist, slot exist, slotName={}", (Object)slotName);
                return;
            }
            String createSlotSQL = String.format("SELECT * FROM pg_create_logical_replication_slot('%s', '%s')", slotName, DECODE_PLUGIN);
            try (PreparedStatement preparedStatement = connection.prepareStatement(createSlotSQL);){
                preparedStatement.execute();
            }
            catch (SQLException ex) {
                if (DUPLICATE_OBJECT_ERROR_CODE.equals(ex.getSQLState())) break block9;
                throw ex;
            }
        }
    }

    private boolean isSlotExisting(Connection connection, String slotName) throws SQLException {
        String checkSlotSQL = "SELECT slot_name FROM pg_replication_slots WHERE slot_name=? AND plugin=?";
        try (PreparedStatement preparedStatement = connection.prepareStatement(checkSlotSQL);){
            boolean bl;
            block12: {
                preparedStatement.setString(1, slotName);
                preparedStatement.setString(2, DECODE_PLUGIN);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    private WALPosition getWalPosition(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.getLogSequenceNumberSQL(connection));){
            WALPosition wALPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    wALPosition = new WALPosition(new PostgreSQLLogSequenceNumber(LogSequenceNumber.valueOf((String)resultSet.getString(1))));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return wALPosition;
        }
    }

    private String getLogSequenceNumberSQL(Connection connection) throws SQLException {
        if (9 == connection.getMetaData().getDatabaseMajorVersion() && 6 <= connection.getMetaData().getDatabaseMinorVersion()) {
            return "SELECT PG_CURRENT_XLOG_LOCATION()";
        }
        if (10 <= connection.getMetaData().getDatabaseMajorVersion()) {
            return "SELECT PG_CURRENT_WAL_LSN()";
        }
        throw new PipelineInternalException("Unsupported PostgreSQL version: " + connection.getMetaData().getDatabaseProductVersion(), new Object[0]);
    }

    public void destroy(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.dropSlotIfExist(connection, slotNameSuffix);
        }
    }

    private void dropSlotIfExist(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = PostgreSQLIngestPositionManager.getUniqueSlotName(connection, slotNameSuffix);
        if (!this.isSlotExisting(connection, slotName)) {
            log.info("dropSlotIfExist, slot not exist, slotName={}", (Object)slotName);
            return;
        }
        log.info("dropSlotIfExist, slot exist, slotName={}", (Object)slotName);
        String dropSlotSQL = "SELECT pg_drop_replication_slot(?)";
        try (PreparedStatement preparedStatement = connection.prepareStatement(dropSlotSQL);){
            preparedStatement.setString(1, slotName);
            preparedStatement.execute();
        }
    }

    public static String getUniqueSlotName(Connection connection, String slotNameSuffix) throws SQLException {
        String slotName = DigestUtils.md5Hex((byte[])String.join((CharSequence)"_", connection.getCatalog(), slotNameSuffix).getBytes());
        return String.format("%s_%s", SLOT_NAME_PREFIX, slotName);
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

