/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.BaseTimestampUtils;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingException;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.decode.DecodingPlugin;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.AbstractWALEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.BeginTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.CommitTXEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.DeleteRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.PlaceholderEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.UpdateRowEvent;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.wal.event.WriteRowEvent;

public final class TestDecodingPlugin
implements DecodingPlugin {
    private final BaseTimestampUtils timestampUtils;

    @Override
    public AbstractWALEvent decode(ByteBuffer data, BaseLogSequenceNumber logSequenceNumber) {
        String type = this.readEventType(data);
        AbstractWALEvent result = type.startsWith("BEGIN") ? new BeginTXEvent(Long.parseLong(this.readNextSegment(data)), null) : (type.startsWith("COMMIT") ? new CommitTXEvent(Long.parseLong(this.readNextSegment(data)), null) : ("table".equals(type) ? this.readTableEvent(data) : new PlaceholderEvent()));
        result.setLogSequenceNumber(logSequenceNumber);
        return result;
    }

    private String readEventType(ByteBuffer data) {
        return this.readNextSegment(data);
    }

    private AbstractRowEvent readTableEvent(ByteBuffer data) {
        AbstractRowEvent result;
        PipelineSQLOperationType type;
        String tableName = this.readTableName(data);
        String rowEventType = this.readRowEventType(data);
        try {
            type = PipelineSQLOperationType.valueOf((String)rowEventType);
        }
        catch (IllegalArgumentException ex) {
            throw new IngestException("Unknown rowEventType: " + rowEventType);
        }
        switch (type) {
            case INSERT: {
                result = this.readWriteRowEvent(data);
                break;
            }
            case UPDATE: {
                result = this.readUpdateRowEvent(data);
                break;
            }
            case DELETE: {
                result = this.readDeleteRowEvent(data);
                break;
            }
            default: {
                throw new IngestException("Unknown rowEventType: " + rowEventType);
            }
        }
        String[] tableMetaData = tableName.split("\\.");
        result.setSchemaName(tableMetaData[0]);
        result.setTableName(tableMetaData[1].substring(0, tableMetaData[1].length() - 1));
        return result;
    }

    private AbstractRowEvent readWriteRowEvent(ByteBuffer data) {
        WriteRowEvent result = new WriteRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setAfterRow(afterColumns);
        return result;
    }

    private AbstractRowEvent readUpdateRowEvent(ByteBuffer data) {
        UpdateRowEvent result = new UpdateRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setAfterRow(afterColumns);
        return result;
    }

    private AbstractRowEvent readDeleteRowEvent(ByteBuffer data) {
        DeleteRowEvent result = new DeleteRowEvent();
        LinkedList<Object> afterColumns = new LinkedList<Object>();
        while (data.hasRemaining()) {
            afterColumns.add(this.readColumn(data));
        }
        result.setPrimaryKeys(afterColumns);
        return result;
    }

    private String readTableName(ByteBuffer data) {
        return this.readNextSegment(data);
    }

    private String readRowEventType(ByteBuffer data) {
        String result = this.readNextSegment(data);
        return result.substring(0, result.length() - 1);
    }

    private Object readColumn(ByteBuffer data) {
        this.readColumnName(data);
        String columnType = this.readColumnType(data);
        data.get();
        return this.readColumnData(data, columnType);
    }

    private String readColumnName(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if ('[' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private String readColumnType(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if (']' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private Object readColumnData(ByteBuffer data, String columnType) {
        data.mark();
        if (110 == data.get() && data.remaining() >= 3 && 117 == data.get() && 108 == data.get()) {
            if (data.hasRemaining()) {
                data.get();
            }
            return null;
        }
        data.reset();
        if (columnType.startsWith("numeric")) {
            return new BigDecimal(this.readNextSegment(data));
        }
        if (columnType.startsWith("bit") || columnType.startsWith("bit varying")) {
            return this.readNextSegment(data);
        }
        switch (columnType) {
            case "smallint": {
                return Short.parseShort(this.readNextSegment(data));
            }
            case "integer": {
                return Integer.parseInt(this.readNextSegment(data));
            }
            case "bigint": {
                return Long.parseLong(this.readNextSegment(data));
            }
            case "real": {
                return Float.valueOf(Float.parseFloat(this.readNextSegment(data)));
            }
            case "double precision": {
                return Double.parseDouble(this.readNextSegment(data));
            }
            case "boolean": {
                return Boolean.parseBoolean(this.readNextSegment(data));
            }
            case "time without time zone": {
                try {
                    return this.timestampUtils.toTime(null, this.readNextString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException(ex);
                }
            }
            case "date": {
                return Date.valueOf(this.readNextString(data));
            }
            case "timestamp without time zone": {
                try {
                    return this.timestampUtils.toTimestamp(null, this.readNextString(data));
                }
                catch (SQLException ex) {
                    throw new DecodingException(ex);
                }
            }
            case "bytea": {
                return this.decodeHex(this.readNextString(data).substring(2));
            }
            case "json": 
            case "jsonb": {
                return this.readNextJson(data);
            }
        }
        return this.readNextString(data);
    }

    private String readNextSegment(ByteBuffer data) {
        StringBuilder eventType = new StringBuilder();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            if (' ' == c) {
                return eventType.toString();
            }
            eventType.append(c);
        }
        return eventType.toString();
    }

    private String readNextJson(ByteBuffer data) {
        data.get();
        int offset = 0;
        int startPosition = data.position();
        int level = 0;
        while (data.hasRemaining()) {
            ++offset;
            char c = (char)data.get();
            if ('{' == c) {
                ++level;
                continue;
            }
            if ('}' != c || 0 != --level) continue;
            if (39 != data.get()) {
                throw new IngestException("Read json data unexpected exception");
            }
            if (data.hasRemaining()) {
                data.get();
            }
            return this.readStringSegment(data, startPosition, offset).replace("''", "'");
        }
        return null;
    }

    private String readStringSegment(ByteBuffer data, int startPosition, int offset) {
        byte[] result = new byte[offset];
        for (int i = 0; i < offset; ++i) {
            result[i] = data.get(startPosition + i);
        }
        return new String(result, StandardCharsets.UTF_8);
    }

    private String readNextString(ByteBuffer data) {
        int offset = 0;
        data.get();
        int startPosition = data.position();
        while (data.hasRemaining()) {
            char c = (char)data.get();
            ++offset;
            if ('\'' != c) continue;
            if (!data.hasRemaining()) {
                return this.readStringSegment(data, startPosition, --offset).replace("''", "'");
            }
            char c2 = (char)data.get();
            if ('\'' == c2) {
                ++offset;
                continue;
            }
            if (' ' != c2) continue;
            return this.readStringSegment(data, startPosition, --offset).replace("''", "'");
        }
        return this.readStringSegment(data, startPosition, offset);
    }

    private byte[] decodeHex(String hexString) {
        int dataLength = hexString.length();
        Preconditions.checkArgument((0 == (dataLength & 1) ? 1 : 0) != 0, (String)"Illegal hex data `%s`", (Object)hexString);
        if (0 == dataLength) {
            return new byte[0];
        }
        byte[] result = new byte[dataLength >>> 1];
        for (int i = 0; i < dataLength; i += 2) {
            result[i >>> 1] = this.decodeHexByte(hexString, i);
        }
        return result;
    }

    private byte decodeHexByte(String hexString, int index) {
        int firstHexChar = Character.digit(hexString.charAt(index), 16);
        int secondHexChar = Character.digit(hexString.charAt(index + 1), 16);
        Preconditions.checkArgument((-1 != firstHexChar && -1 != secondHexChar ? 1 : 0) != 0, (String)"Illegal hex byte `%s` in index `%d`", (Object)hexString, (int)index);
        return (byte)((firstHexChar << 4) + secondHexChar);
    }

    @Generated
    public TestDecodingPlugin(BaseTimestampUtils timestampUtils) {
        this.timestampUtils = timestampUtils;
    }
}

