/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public final class PostgreSQLPipelineFreemarkerManager {
    private static final Map<Integer, String> VERSION_PATHS = new LinkedHashMap<Integer, String>();
    private static final Configuration TEMPLATE_CONFIG = PostgreSQLPipelineFreemarkerManager.createTemplateConfiguration();

    private static Configuration createTemplateConfiguration() {
        Configuration result = new Configuration(Configuration.VERSION_2_3_31);
        result.setClassForTemplateLoading(PostgreSQLPipelineFreemarkerManager.class, "/template");
        result.setDefaultEncoding("UTF-8");
        return result;
    }

    public static String getSQLByVersion(Map<String, Object> dataModel, String pathFormat, int majorVersion, int minorVersion) {
        String string;
        int version = majorVersion * 10000 + minorVersion;
        try (StringWriter result = new StringWriter();){
            PostgreSQLPipelineFreemarkerManager.findTemplate(pathFormat, version).process(dataModel, (Writer)result);
            string = result.toString();
        }
        return string;
    }

    private static Template findTemplate(String pathFormat, int version) throws IOException {
        for (Map.Entry<Integer, String> entry : VERSION_PATHS.entrySet()) {
            if (entry.getKey() > version) continue;
            try {
                return TEMPLATE_CONFIG.getTemplate(String.format(pathFormat, entry.getValue()));
            }
            catch (TemplateNotFoundException templateNotFoundException) {
            }
        }
        return TEMPLATE_CONFIG.getTemplate(String.format(pathFormat, "default"));
    }

    @Generated
    private PostgreSQLPipelineFreemarkerManager() {
    }

    static {
        VERSION_PATHS.put(120000, "12_plus");
        VERSION_PATHS.put(110000, "11_plus");
        VERSION_PATHS.put(100000, "10_plus");
        VERSION_PATHS.put(90600, "9.6_plus");
        VERSION_PATHS.put(90500, "9.5_plus");
        VERSION_PATHS.put(90400, "9.4_plus");
        VERSION_PATHS.put(90300, "9.3_plus");
        VERSION_PATHS.put(90200, "9.2_plus");
        VERSION_PATHS.put(90100, "9.1_plus");
        VERSION_PATHS.put(90000, "9.0_plus");
    }
}

