/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.preparer;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.checker.DataSourceCheckEngine;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceWrapper;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.execute.ExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.importer.SingleChannelConsumerImporter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.DialectIncrementalDumperCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobOffsetInfo;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.PipelineJobDataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.option.DialectPipelineJobDataSourcePrepareOption;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTaskUtils;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.context.MigrationJobItemContext;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.lock.GlobalLockNames;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.mode.lock.GlobalLockDefinition;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobPreparer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobPreparer.class);
    private final MigrationJobType jobType = new MigrationJobType();
    private final PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager = new PipelineJobItemManager((YamlPipelineJobItemProgressSwapper)this.jobType.getYamlJobItemProgressSwapper());

    public void prepare(MigrationJobItemContext jobItemContext) throws SQLException, PipelineJobCancelingException {
        ShardingSpherePreconditions.checkState((boolean)StandardPipelineDataSourceConfiguration.class.equals(jobItemContext.getTaskConfig().getDumperContext().getCommonContext().getDataSourceConfig().getClass()), () -> new UnsupportedSQLOperationException("Migration inventory dumper only support StandardPipelineDataSourceConfiguration"));
        DatabaseType sourceDatabaseType = jobItemContext.getJobConfig().getSourceDatabaseType();
        new DataSourceCheckEngine(sourceDatabaseType).checkSourceDataSources(Collections.singleton(jobItemContext.getSourceDataSource()));
        if (jobItemContext.isStopping()) {
            throw new PipelineJobCancelingException();
        }
        this.prepareAndCheckTargetWithLock(jobItemContext);
        if (jobItemContext.isStopping()) {
            throw new PipelineJobCancelingException();
        }
        boolean isIncrementalSupported = DatabaseTypedSPILoader.findService(DialectIncrementalDumperCreator.class, (DatabaseType)sourceDatabaseType).isPresent();
        if (isIncrementalSupported) {
            this.prepareIncremental(jobItemContext);
        }
        this.initInventoryTasks(jobItemContext);
        if (isIncrementalSupported) {
            this.initIncrementalTasks(jobItemContext);
            if (jobItemContext.isStopping()) {
                throw new PipelineJobCancelingException();
            }
        }
        log.info("prepare, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobItemContext.getJobId(), jobItemContext.getShardingItem(), jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndCheckTargetWithLock(MigrationJobItemContext jobItemContext) throws SQLException {
        block5: {
            String jobId;
            block4: {
                long startTimeMillis;
                GlobalLockDefinition lockDefinition;
                LockContext lockContext;
                block3: {
                    MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
                    jobId = jobConfig.getJobId();
                    lockContext = PipelineContextManager.getContext((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getContextManager().getInstanceContext().getLockContext();
                    if (!this.jobItemManager.getProgress(jobId, jobItemContext.getShardingItem()).isPresent()) {
                        this.jobItemManager.persistProgress((PipelineJobItemContext)jobItemContext);
                    }
                    lockDefinition = new GlobalLockDefinition(String.format(GlobalLockNames.PREPARE.getLockName(), jobConfig.getJobId()));
                    startTimeMillis = System.currentTimeMillis();
                    if (!lockContext.tryLock((LockDefinition)lockDefinition, 600000L)) break block4;
                    log.info("try lock success, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                    try {
                        JobOffsetInfo offsetInfo = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobFacade().getOffset().load(jobId);
                        if (offsetInfo.isTargetSchemaTableCreated()) break block3;
                        jobItemContext.setStatus(JobStatus.PREPARING);
                        this.jobItemManager.updateStatus(jobId, jobItemContext.getShardingItem(), JobStatus.PREPARING);
                        this.prepareAndCheckTarget(jobItemContext);
                        PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobId)).getJobFacade().getOffset().persist(jobId, new JobOffsetInfo(true));
                    }
                    catch (Throwable throwable) {
                        log.info("unlock, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                        lockContext.unlock((LockDefinition)lockDefinition);
                        throw throwable;
                    }
                }
                log.info("unlock, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                lockContext.unlock((LockDefinition)lockDefinition);
                break block5;
            }
            log.warn("try lock failed, jobId={}, shardingItem={}", (Object)jobId, (Object)jobItemContext.getShardingItem());
        }
    }

    private void prepareAndCheckTarget(MigrationJobItemContext jobItemContext) throws SQLException {
        DatabaseType targetDatabaseType = jobItemContext.getJobConfig().getTargetDatabaseType();
        if (jobItemContext.isSourceTargetDatabaseTheSame()) {
            this.prepareTarget(jobItemContext, targetDatabaseType);
        }
        if (null == jobItemContext.getInitProgress()) {
            PipelineDataSourceWrapper targetDataSource = jobItemContext.getDataSourceManager().getDataSource(jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig());
            new DataSourceCheckEngine(targetDatabaseType).checkTargetDataSources(Collections.singleton(targetDataSource), jobItemContext.getTaskConfig().getImporterConfig());
        }
    }

    private void prepareTarget(MigrationJobItemContext jobItemContext, DatabaseType targetDatabaseType) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        Collection<CreateTableConfiguration> createTableConfigs = jobItemContext.getTaskConfig().getCreateTableConfigurations();
        PipelineDataSourceManager dataSourceManager = jobItemContext.getDataSourceManager();
        PipelineJobDataSourcePreparer preparer = new PipelineJobDataSourcePreparer((DialectPipelineJobDataSourcePrepareOption)DatabaseTypedSPILoader.getService(DialectPipelineJobDataSourcePrepareOption.class, (DatabaseType)targetDatabaseType));
        preparer.prepareTargetSchemas(new PrepareTargetSchemasParameter(targetDatabaseType, createTableConfigs, dataSourceManager));
        ShardingSphereMetaData metaData = PipelineContextManager.getContext((PipelineContextKey)PipelineJobIdUtils.parseContextKey((String)jobConfig.getJobId())).getContextManager().getMetaDataContexts().getMetaData();
        SQLParserEngine sqlParserEngine = ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(metaData.getDatabase(jobConfig.getTargetDatabaseName()).getProtocolType());
        preparer.prepareTargetTables(new PrepareTargetTablesParameter(createTableConfigs, dataSourceManager, sqlParserEngine));
    }

    private void prepareIncremental(MigrationJobItemContext jobItemContext) {
        MigrationTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        JobItemIncrementalTasksProgress initIncremental = null == jobItemContext.getInitProgress() ? null : jobItemContext.getInitProgress().getIncremental();
        try {
            DatabaseType databaseType = taskConfig.getDumperContext().getCommonContext().getDataSourceConfig().getDatabaseType();
            IngestPosition position = new IncrementalTaskPositionManager(databaseType).getPosition(initIncremental, taskConfig.getDumperContext(), jobItemContext.getDataSourceManager());
            taskConfig.getDumperContext().getCommonContext().setPosition(position);
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobItemContext.getJobId(), ex);
        }
    }

    private void initInventoryTasks(MigrationJobItemContext jobItemContext) {
        InventoryDumperContext inventoryDumperContext = new InventoryDumperContext(jobItemContext.getTaskConfig().getDumperContext().getCommonContext());
        InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter(jobItemContext.getSourceDataSource(), inventoryDumperContext, jobItemContext.getTaskConfig().getImporterConfig());
        jobItemContext.getInventoryTasks().addAll(inventoryTaskSplitter.splitInventoryData((TransmissionJobItemContext)jobItemContext));
    }

    private void initIncrementalTasks(MigrationJobItemContext jobItemContext) {
        MigrationTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        PipelineTableMetaDataLoader sourceMetaDataLoader = jobItemContext.getSourceMetaDataLoader();
        IncrementalDumperContext dumperContext = taskConfig.getDumperContext();
        ExecuteEngine incrementalExecuteEngine = jobItemContext.getJobProcessContext().getIncrementalExecuteEngine();
        IncrementalTaskProgress taskProgress = PipelineTaskUtils.createIncrementalTaskProgress((IngestPosition)dumperContext.getCommonContext().getPosition(), (TransmissionJobItemProgress)jobItemContext.getInitProgress());
        PipelineChannel channel = PipelineTaskUtils.createIncrementalChannel((AlgorithmConfiguration)jobItemContext.getJobProcessContext().getProcessConfiguration().getStreamChannel(), (IncrementalTaskProgress)taskProgress);
        IncrementalDumper dumper = ((DialectIncrementalDumperCreator)DatabaseTypedSPILoader.getService(DialectIncrementalDumperCreator.class, (DatabaseType)dumperContext.getCommonContext().getDataSourceConfig().getDatabaseType())).createIncrementalDumper(dumperContext, dumperContext.getCommonContext().getPosition(), channel, sourceMetaDataLoader);
        List<SingleChannelConsumerImporter> importers = Collections.singletonList(new SingleChannelConsumerImporter(channel, 1, 5L, jobItemContext.getSink(), (PipelineJobProgressListener)jobItemContext));
        IncrementalTask incrementalTask = new IncrementalTask(dumperContext.getCommonContext().getDataSourceName(), incrementalExecuteEngine, (Dumper)dumper, importers, taskProgress);
        jobItemContext.getIncrementalTasks().add((PipelineTask)incrementalTask);
    }

    public void cleanup(MigrationJobConfiguration jobConfig) {
        for (Map.Entry<String, PipelineDataSourceConfiguration> entry : jobConfig.getSources().entrySet()) {
            try {
                new IncrementalTaskPositionManager(entry.getValue().getDatabaseType()).destroyPosition(jobConfig.getJobId(), entry.getValue());
            }
            catch (SQLException ex) {
                log.warn("job destroying failed, jobId={}, dataSourceName={}", new Object[]{jobConfig.getJobId(), entry.getKey(), ex});
            }
        }
    }
}

