/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.rulealtered;

import com.google.common.base.Strings;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.HandleConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.PipelineConfiguration;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.WorkflowConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfigurationFactory;
import org.apache.shardingsphere.data.pipeline.spi.rulealtered.RuleAlteredJobConfigurationPreparer;
import org.apache.shardingsphere.spi.required.RequiredSPIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobConfiguration.class);
    private WorkflowConfiguration workflowConfig;
    private PipelineConfiguration pipelineConfig;
    private HandleConfiguration handleConfig;

    public JobConfiguration(WorkflowConfiguration workflowConfig, PipelineConfiguration pipelineConfig) {
        this.workflowConfig = workflowConfig;
        this.pipelineConfig = pipelineConfig;
    }

    public void buildHandleConfig() {
        PipelineConfiguration pipelineConfig = this.getPipelineConfig();
        HandleConfiguration handleConfig = this.getHandleConfig();
        if (null == handleConfig || null == handleConfig.getJobShardingDataNodes()) {
            RuleAlteredJobConfigurationPreparer preparer = (RuleAlteredJobConfigurationPreparer)RequiredSPIRegistry.getRegisteredService(RuleAlteredJobConfigurationPreparer.class);
            this.handleConfig = handleConfig = preparer.createHandleConfiguration(pipelineConfig);
        }
        if (null == handleConfig.getJobId()) {
            handleConfig.setJobId(String.valueOf(System.nanoTime() - ThreadLocalRandom.current().nextLong(1000000L)));
        }
        if (Strings.isNullOrEmpty((String)handleConfig.getSourceDatabaseType())) {
            PipelineDataSourceConfiguration sourceDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(this.getPipelineConfig().getSource().getType(), this.getPipelineConfig().getSource().getParameter());
            handleConfig.setSourceDatabaseType(sourceDataSourceConfig.getDatabaseType().getName());
        }
        if (Strings.isNullOrEmpty((String)handleConfig.getTargetDatabaseType())) {
            PipelineDataSourceConfiguration targetDataSourceConfig = PipelineDataSourceConfigurationFactory.newInstance(this.getPipelineConfig().getTarget().getType(), this.getPipelineConfig().getTarget().getParameter());
            handleConfig.setTargetDatabaseType(targetDataSourceConfig.getDatabaseType().getName());
        }
        if (null == handleConfig.getJobShardingItem()) {
            handleConfig.setJobShardingItem(0);
        }
    }

    @Generated
    public JobConfiguration() {
    }

    @Generated
    public JobConfiguration(WorkflowConfiguration workflowConfig, PipelineConfiguration pipelineConfig, HandleConfiguration handleConfig) {
        this.workflowConfig = workflowConfig;
        this.pipelineConfig = pipelineConfig;
        this.handleConfig = handleConfig;
    }

    @Generated
    public WorkflowConfiguration getWorkflowConfig() {
        return this.workflowConfig;
    }

    @Generated
    public PipelineConfiguration getPipelineConfig() {
        return this.pipelineConfig;
    }

    @Generated
    public HandleConfiguration getHandleConfig() {
        return this.handleConfig;
    }

    @Generated
    public void setWorkflowConfig(WorkflowConfiguration workflowConfig) {
        this.workflowConfig = workflowConfig;
    }

    @Generated
    public void setPipelineConfig(PipelineConfiguration pipelineConfig) {
        this.pipelineConfig = pipelineConfig;
    }

    @Generated
    public void setHandleConfig(HandleConfiguration handleConfig) {
        this.handleConfig = handleConfig;
    }
}

