/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;

public final class ShardingSpherePipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "ShardingSphereJDBC";
    private final String parameter;
    private final YamlRootConfiguration rootConfig;
    private final DatabaseType databaseType;

    public ShardingSpherePipelineDataSourceConfiguration(String parameter) {
        this.parameter = parameter;
        this.rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)parameter, YamlRootConfiguration.class, (boolean)true);
        Map props = (Map)this.rootConfig.getDataSources().values().iterator().next();
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)this.getJdbcUrl(props));
    }

    public ShardingSpherePipelineDataSourceConfiguration(YamlRootConfiguration rootConfig) {
        YamlParameterConfiguration parameterConfig = new YamlParameterConfiguration(rootConfig.getDataSources(), rootConfig.getRules());
        this.parameter = YamlEngine.marshal((Object)parameterConfig);
        this.rootConfig = rootConfig;
        Map props = (Map)rootConfig.getDataSources().values().iterator().next();
        this.databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL((String)this.getJdbcUrl(props));
    }

    private String getJdbcUrl(Map<String, Object> props) {
        Object result = props.getOrDefault("url", props.get("jdbcUrl"));
        Preconditions.checkNotNull((Object)result, (Object)"url or jdbcUrl is required.");
        return result.toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.rootConfig;
    }

    @Override
    public void appendJDBCQueryProperties(Properties queryProps) {
        this.rootConfig.getDataSources().forEach((key, value) -> {
            String jdbcUrlKey = value.containsKey("url") ? "url" : "jdbcUrl";
            value.replace(jdbcUrlKey, new JdbcUrlAppender().appendQueryProperties(value.get(jdbcUrlKey).toString(), queryProps));
        });
    }

    public StandardPipelineDataSourceConfiguration getActualDataSourceConfig(String actualDataSourceName) {
        Map yamlDataSourceConfig = (Map)this.rootConfig.getDataSources().get(actualDataSourceName);
        Preconditions.checkNotNull((Object)yamlDataSourceConfig, (String)"actualDataSourceName '{}' does not exist", (Object)actualDataSourceName);
        return new StandardPipelineDataSourceConfiguration(yamlDataSourceConfig);
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlRootConfiguration getRootConfig() {
        return this.rootConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingSpherePipelineDataSourceConfiguration)) {
            return false;
        }
        ShardingSpherePipelineDataSourceConfiguration other = (ShardingSpherePipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    private static class YamlParameterConfiguration
    implements YamlConfiguration {
        private Map<String, Map<String, Object>> dataSources = new HashMap<String, Map<String, Object>>();
        private Collection<YamlRuleConfiguration> rules = new LinkedList<YamlRuleConfiguration>();

        @Generated
        public YamlParameterConfiguration(Map<String, Map<String, Object>> dataSources, Collection<YamlRuleConfiguration> rules) {
            this.dataSources = dataSources;
            this.rules = rules;
        }

        @Generated
        public YamlParameterConfiguration() {
        }

        @Generated
        public Map<String, Map<String, Object>> getDataSources() {
            return this.dataSources;
        }

        @Generated
        public Collection<YamlRuleConfiguration> getRules() {
            return this.rules;
        }

        @Generated
        public void setDataSources(Map<String, Map<String, Object>> dataSources) {
            this.dataSources = dataSources;
        }

        @Generated
        public void setRules(Collection<YamlRuleConfiguration> rules) {
            this.rules = rules;
        }
    }
}

