/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.constant;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum MySQLColumnType {
    MYSQL_TYPE_DECIMAL(0),
    MYSQL_TYPE_TINY(1),
    MYSQL_TYPE_SHORT(2),
    MYSQL_TYPE_LONG(3),
    MYSQL_TYPE_FLOAT(4),
    MYSQL_TYPE_DOUBLE(5),
    MYSQL_TYPE_NULL(6),
    MYSQL_TYPE_TIMESTAMP(7),
    MYSQL_TYPE_LONGLONG(8),
    MYSQL_TYPE_INT24(9),
    MYSQL_TYPE_DATE(10),
    MYSQL_TYPE_TIME(11),
    MYSQL_TYPE_DATETIME(12),
    MYSQL_TYPE_YEAR(13),
    MYSQL_TYPE_NEWDATE(14),
    MYSQL_TYPE_VARCHAR(15),
    MYSQL_TYPE_BIT(16),
    MYSQL_TYPE_TIMESTAMP2(17),
    MYSQL_TYPE_DATETIME2(18),
    MYSQL_TYPE_TIME2(19),
    MySQL_TYPE_JSON(245),
    MYSQL_TYPE_NEWDECIMAL(246),
    MYSQL_TYPE_ENUM(247),
    MYSQL_TYPE_SET(248),
    MYSQL_TYPE_TINY_BLOB(249),
    MYSQL_TYPE_MEDIUM_BLOB(250),
    MYSQL_TYPE_LONG_BLOB(251),
    MYSQL_TYPE_BLOB(252),
    MYSQL_TYPE_VAR_STRING(253),
    MYSQL_TYPE_STRING(254),
    MYSQL_TYPE_GEOMETRY(255);

    private static final Map<Integer, MySQLColumnType> JDBC_TYPE_AND_COLUMN_TYPE_MAP;
    private final int value;

    public static MySQLColumnType valueOfJDBCType(int jdbcType) {
        if (JDBC_TYPE_AND_COLUMN_TYPE_MAP.containsKey(jdbcType)) {
            return JDBC_TYPE_AND_COLUMN_TYPE_MAP.get(jdbcType);
        }
        throw new IllegalArgumentException(String.format("Cannot find JDBC type '%s' in column type", jdbcType));
    }

    public static MySQLColumnType valueOf(int value) {
        for (MySQLColumnType each : MySQLColumnType.values()) {
            if (value != each.value) continue;
            return each;
        }
        throw new IllegalArgumentException(String.format("Cannot find value '%s' in column type", value));
    }

    @Generated
    private MySQLColumnType(int value) {
        this.value = value;
    }

    @Generated
    public int getValue() {
        return this.value;
    }

    static {
        JDBC_TYPE_AND_COLUMN_TYPE_MAP = new HashMap<Integer, MySQLColumnType>(MySQLColumnType.values().length, 1.0f);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-7, MYSQL_TYPE_BIT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-6, MYSQL_TYPE_TINY);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(5, MYSQL_TYPE_SHORT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(4, MYSQL_TYPE_LONG);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-5, MYSQL_TYPE_LONGLONG);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(6, MYSQL_TYPE_FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(7, MYSQL_TYPE_FLOAT);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(8, MYSQL_TYPE_DOUBLE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2, MYSQL_TYPE_NEWDECIMAL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(3, MYSQL_TYPE_NEWDECIMAL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(1, MYSQL_TYPE_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(12, MYSQL_TYPE_VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-1, MYSQL_TYPE_VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(91, MYSQL_TYPE_DATE);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(92, MYSQL_TYPE_TIME);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(93, MYSQL_TYPE_TIMESTAMP);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-2, MYSQL_TYPE_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-3, MYSQL_TYPE_VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(-4, MYSQL_TYPE_VAR_STRING);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(0, MYSQL_TYPE_NULL);
        JDBC_TYPE_AND_COLUMN_TYPE_MAP.put(2004, MYSQL_TYPE_BLOB);
    }
}

