/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLColumnType;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.blob.MySQLBlobBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.decimal.MySQLDecimalBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.decimal.MySQLDoubleBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.decimal.MySQLFloatBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.integer.MySQLInt24BinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.integer.MySQLLongBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.integer.MySQLLongLongBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.integer.MySQLShortBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.integer.MySQLTinyBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string.MySQLJsonBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string.MySQLStringBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string.MySQLVarcharBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLDateBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLDatetime2BinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLDatetimeBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLTime2BinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLTimeBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLTimestamp2BinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLTimestampBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.time.MySQLYearBinlogProtocolValue;

public final class MySQLBinlogProtocolValueFactory {
    private static final Map<MySQLColumnType, MySQLBinlogProtocolValue> BINLOG_PROTOCOL_VALUES = new HashMap<MySQLColumnType, MySQLBinlogProtocolValue>();

    private static void registerIntegerTypeValue() {
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_TINY, new MySQLTinyBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_SHORT, new MySQLShortBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_INT24, new MySQLInt24BinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_LONG, new MySQLLongBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_LONGLONG, new MySQLLongLongBinlogProtocolValue());
    }

    private static void registerDecimalTypeValue() {
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_NEWDECIMAL, new MySQLDecimalBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_DOUBLE, new MySQLDoubleBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_FLOAT, new MySQLFloatBinlogProtocolValue());
    }

    private static void registerTimeTypeValue() {
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_YEAR, new MySQLYearBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_DATE, new MySQLDateBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_TIME, new MySQLTimeBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_TIME2, new MySQLTime2BinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_TIMESTAMP, new MySQLTimestampBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_TIMESTAMP2, new MySQLTimestamp2BinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_DATETIME, new MySQLDatetimeBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_DATETIME2, new MySQLDatetime2BinlogProtocolValue());
    }

    private static void registerStringTypeValue() {
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_STRING, new MySQLStringBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_VARCHAR, new MySQLVarcharBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_VAR_STRING, new MySQLVarcharBinlogProtocolValue());
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MySQL_TYPE_JSON, new MySQLJsonBinlogProtocolValue());
    }

    private static void registerBlobTypeValue() {
        BINLOG_PROTOCOL_VALUES.put(MySQLColumnType.MYSQL_TYPE_BLOB, new MySQLBlobBinlogProtocolValue());
    }

    public static MySQLBinlogProtocolValue getBinlogProtocolValue(MySQLColumnType columnType) {
        Preconditions.checkArgument((boolean)BINLOG_PROTOCOL_VALUES.containsKey((Object)columnType), (String)"Cannot find MySQL type '%s' in column type when process binlog protocol value", (Object[])new Object[]{columnType});
        return BINLOG_PROTOCOL_VALUES.get((Object)columnType);
    }

    @Generated
    private MySQLBinlogProtocolValueFactory() {
    }

    static {
        MySQLBinlogProtocolValueFactory.registerIntegerTypeValue();
        MySQLBinlogProtocolValueFactory.registerDecimalTypeValue();
        MySQLBinlogProtocolValueFactory.registerTimeTypeValue();
        MySQLBinlogProtocolValueFactory.registerStringTypeValue();
        MySQLBinlogProtocolValueFactory.registerBlobTypeValue();
    }
}

