/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.string;

import java.io.Serializable;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLColumnType;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.database.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLStringBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        switch (MySQLColumnType.valueOf(columnDef.getColumnMeta() >> 8)) {
            case MYSQL_TYPE_ENUM: {
                return this.readEnumValue(columnDef.getColumnMeta() & 0xFF, payload);
            }
            case MYSQL_TYPE_SET: {
                return Byte.valueOf(payload.getByteBuf().readByte());
            }
            case MYSQL_TYPE_STRING: {
                return payload.readStringFix(payload.getByteBuf().readUnsignedByte());
            }
        }
        throw new UnsupportedOperationException();
    }

    private Serializable readEnumValue(int meta, MySQLPacketPayload payload) {
        switch (meta) {
            case 1: {
                return Integer.valueOf(payload.readInt1());
            }
            case 2: {
                return Integer.valueOf(payload.readInt2());
            }
        }
        throw new UnsupportedOperationException("MySQL Enum meta in binlog only include value 1 or 2, but actual is " + meta);
    }
}

