/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.binlog;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.MySQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLComBinlogDumpCommandPacket
extends MySQLCommandPacket {
    public static final int BINLOG_DUMP_NON_BLOCK = 1;
    private final int binlogPos;
    private final int flags;
    private final int serverId;
    private final String binlogFilename;

    public MySQLComBinlogDumpCommandPacket(int binlogPos, int serverId, String binlogFilename) {
        super(MySQLCommandPacketType.COM_BINLOG_DUMP);
        this.binlogPos = binlogPos;
        this.flags = 0;
        this.serverId = serverId;
        this.binlogFilename = binlogFilename;
    }

    public MySQLComBinlogDumpCommandPacket(MySQLPacketPayload payload) {
        super(MySQLCommandPacketType.COM_BINLOG_DUMP);
        this.binlogPos = payload.readInt4();
        this.flags = payload.readInt2();
        this.serverId = payload.readInt4();
        this.binlogFilename = payload.readStringEOF();
    }

    @Override
    protected void doWrite(MySQLPacketPayload payload) {
        payload.writeInt4(this.binlogPos);
        payload.writeInt2(this.flags);
        payload.writeInt4(this.serverId);
        payload.writeStringEOF(this.binlogFilename);
    }

    @Generated
    public int getBinlogPos() {
        return this.binlogPos;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public int getServerId() {
        return this.serverId;
    }

    @Generated
    public String getBinlogFilename() {
        return this.binlogFilename;
    }

    @Generated
    public String toString() {
        return "MySQLComBinlogDumpCommandPacket(binlogPos=" + this.getBinlogPos() + ", flags=" + this.getFlags() + ", serverId=" + this.getServerId() + ", binlogFilename=" + this.getBinlogFilename() + ")";
    }
}

