/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query;

import com.google.common.base.Preconditions;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLColumnType;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLColumnDefinition41Packet
implements MySQLPacket {
    private static final String CATALOG = "def";
    private static final int NEXT_LENGTH = 12;
    private final int sequenceId;
    private final int characterSet;
    private final int flags;
    private final String schema;
    private final String table;
    private final String orgTable;
    private final String name;
    private final String orgName;
    private final int columnLength;
    private final MySQLColumnType columnType;
    private final int decimals;

    public MySQLColumnDefinition41Packet(int sequenceId, ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        this(sequenceId, resultSetMetaData.getSchemaName(columnIndex), resultSetMetaData.getTableName(columnIndex), resultSetMetaData.getTableName(columnIndex), resultSetMetaData.getColumnLabel(columnIndex), resultSetMetaData.getColumnName(columnIndex), resultSetMetaData.getColumnDisplaySize(columnIndex), MySQLColumnType.valueOfJDBCType(resultSetMetaData.getColumnType(columnIndex)), resultSetMetaData.getScale(columnIndex));
    }

    public MySQLColumnDefinition41Packet(int sequenceId, String schema, String table, String orgTable, String name, String orgName, int columnLength, MySQLColumnType columnType, int decimals) {
        this(sequenceId, 0, schema, table, orgTable, name, orgName, columnLength, columnType, decimals);
    }

    public MySQLColumnDefinition41Packet(int sequenceId, int flags, String schema, String table, String orgTable, String name, String orgName, int columnLength, MySQLColumnType columnType, int decimals) {
        this.sequenceId = sequenceId;
        this.characterSet = 33;
        this.flags = flags;
        this.schema = schema;
        this.table = table;
        this.orgTable = orgTable;
        this.name = name;
        this.orgName = orgName;
        this.columnLength = columnLength;
        this.columnType = columnType;
        this.decimals = decimals;
    }

    public MySQLColumnDefinition41Packet(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((boolean)CATALOG.equals(payload.readStringLenenc()));
        this.schema = payload.readStringLenenc();
        this.table = payload.readStringLenenc();
        this.orgTable = payload.readStringLenenc();
        this.name = payload.readStringLenenc();
        this.orgName = payload.readStringLenenc();
        Preconditions.checkArgument((12L == payload.readIntLenenc() ? 1 : 0) != 0);
        this.characterSet = payload.readInt2();
        this.columnLength = payload.readInt4();
        this.columnType = MySQLColumnType.valueOf(payload.readInt1());
        this.flags = payload.readInt2();
        this.decimals = payload.readInt1();
        payload.skipReserved(2);
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeStringLenenc(CATALOG);
        payload.writeStringLenenc(this.schema);
        payload.writeStringLenenc(this.table);
        payload.writeStringLenenc(this.orgTable);
        payload.writeStringLenenc(this.name);
        payload.writeStringLenenc(this.orgName);
        payload.writeIntLenenc(12L);
        payload.writeInt2(this.characterSet);
        payload.writeInt4(this.columnLength);
        payload.writeInt1(this.columnType.getValue());
        payload.writeInt2(this.flags);
        payload.writeInt1(this.decimals);
        payload.writeReserved(2);
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }
}

