/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLColumnType;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.MySQLNullBitmap;
import org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinaryResultSetRowPacket
implements MySQLPacket {
    private static final int PACKET_HEADER = 0;
    private static final int NULL_BITMAP_OFFSET = 2;
    private final int sequenceId;
    private final List<Object> data;
    private final List<MySQLColumnType> columnTypes;

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(0);
        this.writeNullBitmap(payload);
        this.writeValues(payload);
    }

    private void writeNullBitmap(MySQLPacketPayload payload) {
        for (int each : this.getNullBitmap().getNullBitmap()) {
            payload.writeInt1(each);
        }
    }

    private MySQLNullBitmap getNullBitmap() {
        MySQLNullBitmap result = new MySQLNullBitmap(this.columnTypes.size(), 2);
        for (int columnIndex = 0; columnIndex < this.columnTypes.size(); ++columnIndex) {
            if (null != this.data.get(columnIndex)) continue;
            result.setNullBit(columnIndex);
        }
        return result;
    }

    private void writeValues(MySQLPacketPayload payload) {
        for (int i = 0; i < this.columnTypes.size(); ++i) {
            Object value = this.data.get(i);
            if (null == value) continue;
            MySQLBinaryProtocolValueFactory.getBinaryProtocolValue(this.columnTypes.get(i)).write(payload, value);
        }
    }

    @Generated
    public MySQLBinaryResultSetRowPacket(int sequenceId, List<Object> data, List<MySQLColumnType> columnTypes) {
        this.sequenceId = sequenceId;
        this.data = data;
        this.columnTypes = columnTypes;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }
}

