/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.command.query.binary.execute;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLNullBitmap {
    private final int offset;
    private final int[] nullBitmap;

    public MySQLNullBitmap(int columnsNumbers, int offset) {
        this.offset = offset;
        this.nullBitmap = new int[this.calculateLength(columnsNumbers, offset)];
    }

    public MySQLNullBitmap(int columnNumbers, MySQLPacketPayload payload) {
        this.offset = 0;
        this.nullBitmap = new int[this.calculateLength(columnNumbers, 0)];
        this.fillBitmap(payload);
    }

    private void fillBitmap(MySQLPacketPayload payload) {
        for (int i = 0; i < this.nullBitmap.length; ++i) {
            this.nullBitmap[i] = payload.readInt1();
        }
    }

    private int calculateLength(int columnsNumbers, int offset) {
        return (columnsNumbers + offset + 7) / 8;
    }

    public boolean isNullParameter(int index) {
        return (this.nullBitmap[this.getBytePosition(index)] & 1 << this.getBitPosition(index)) != 0;
    }

    public void setNullBit(int index) {
        this.nullBitmap[this.getBytePosition((int)index)] = 1 << this.getBitPosition(index);
    }

    private int getBytePosition(int index) {
        return (index + this.offset) / 8;
    }

    private int getBitPosition(int index) {
        return (index + this.offset) % 8;
    }

    @Generated
    public int[] getNullBitmap() {
        return this.nullBitmap;
    }
}

