/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.generic;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.constant.MySQLStatusFlag;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLEofPacket
implements MySQLPacket {
    public static final int HEADER = 254;
    private final int sequenceId;
    private final int warnings;
    private final int statusFlags;

    public MySQLEofPacket(int sequenceId) {
        this(sequenceId, 0, MySQLStatusFlag.SERVER_STATUS_AUTOCOMMIT.getValue());
    }

    public MySQLEofPacket(MySQLPacketPayload payload) {
        this.sequenceId = payload.readInt1();
        Preconditions.checkArgument((254 == payload.readInt1() ? 1 : 0) != 0, (Object)"Header of MySQL EOF packet must be `0xfe`.");
        this.warnings = payload.readInt2();
        this.statusFlags = payload.readInt2();
    }

    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(254);
        payload.writeInt2(this.warnings);
        payload.writeInt2(this.statusFlags);
    }

    @Generated
    public MySQLEofPacket(int sequenceId, int warnings, int statusFlags) {
        this.sequenceId = sequenceId;
        this.warnings = warnings;
        this.statusFlags = statusFlags;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public int getWarnings() {
        return this.warnings;
    }

    @Generated
    public int getStatusFlags() {
        return this.statusFlags;
    }
}

