/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.PostgreSQLColumnDescription;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLRowDescriptionPacket
implements PostgreSQLPacket {
    private final char messageType = PostgreSQLCommandPacketType.ROW_DESCRIPTION.getValue();
    private final int fieldCount;
    private final List<PostgreSQLColumnDescription> columnDescriptions;

    public void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.fieldCount);
        for (PostgreSQLColumnDescription each : this.columnDescriptions) {
            payload.writeStringNul(each.getColumnName());
            payload.writeInt4(each.getTableOID());
            payload.writeInt2(each.getColumnIndex());
            payload.writeInt4(each.getTypeOID());
            payload.writeInt2(each.getColumnLength());
            payload.writeInt4(each.getTypeModifier());
            payload.writeInt2(each.getDataFormat());
        }
    }

    @Generated
    public PostgreSQLRowDescriptionPacket(int fieldCount, List<PostgreSQLColumnDescription> columnDescriptions) {
        this.fieldCount = fieldCount;
        this.columnDescriptions = columnDescriptions;
    }

    @Override
    @Generated
    public char getMessageType() {
        return this.messageType;
    }

    @Generated
    public int getFieldCount() {
        return this.fieldCount;
    }
}

