/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind;

import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.postgresql.constant.PostgreSQLColumnType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.PostgreSQLPacket;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.PostgreSQLCommandPacketType;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.postgresql.packet.command.query.binary.bind.protocol.PostgreSQLBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.postgresql.payload.PostgreSQLPacketPayload;

public final class PostgreSQLBinaryResultSetRowPacket
implements PostgreSQLPacket {
    private final char messageType = PostgreSQLCommandPacketType.DATA_ROW.getValue();
    private final List<Object> data;
    private final List<PostgreSQLColumnType> columnTypes;

    public void write(PostgreSQLPacketPayload payload) {
        payload.writeInt2(this.data.size());
        this.writeValues(payload);
    }

    private void writeValues(PostgreSQLPacketPayload payload) {
        for (int i = 0; i < this.columnTypes.size(); ++i) {
            PostgreSQLBinaryProtocolValue binaryProtocolValue = PostgreSQLBinaryProtocolValueFactory.getBinaryProtocolValue(this.columnTypes.get(i));
            Object value = this.data.get(i);
            payload.writeInt4(binaryProtocolValue.getColumnLength(value));
            binaryProtocolValue.write(payload, value);
        }
    }

    @Generated
    public PostgreSQLBinaryResultSetRowPacket(List<Object> data, List<PostgreSQLColumnType> columnTypes) {
        this.data = data;
        this.columnTypes = columnTypes;
    }

    @Override
    @Generated
    public char getMessageType() {
        return this.messageType;
    }

    @Generated
    public List<Object> getData() {
        return this.data;
    }
}

