/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.postgresql.payload;

import io.netty.buffer.ByteBuf;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.payload.PacketPayload;

public final class PostgreSQLPacketPayload
implements PacketPayload {
    private final ByteBuf byteBuf;

    public int readInt1() {
        return this.byteBuf.readByte() & 0xFF;
    }

    public void writeInt1(int value) {
        this.byteBuf.writeByte(value);
    }

    public int readInt2() {
        return this.byteBuf.readShort() & 0xFFFF;
    }

    public void writeInt2(int value) {
        this.byteBuf.writeShort(value);
    }

    public int readInt4() {
        return this.byteBuf.readInt();
    }

    public void writeInt4(int value) {
        this.byteBuf.writeInt(value);
    }

    public long readInt8() {
        return this.byteBuf.readLong();
    }

    public void writeInt8(long value) {
        this.byteBuf.writeLong(value);
    }

    public void writeBytes(byte[] value) {
        this.byteBuf.writeBytes(value);
    }

    public int bytesBeforeZero() {
        return this.byteBuf.bytesBefore((byte)0);
    }

    public String readStringNul() {
        byte[] result = new byte[this.byteBuf.bytesBefore((byte)0)];
        this.byteBuf.readBytes(result);
        this.byteBuf.skipBytes(1);
        return new String(result);
    }

    public void writeStringNul(String value) {
        this.byteBuf.writeBytes(value.getBytes());
        this.byteBuf.writeByte(0);
    }

    public void writeStringEOF(String value) {
        this.byteBuf.writeBytes(value.getBytes());
    }

    public void skipReserved(int length) {
        this.byteBuf.skipBytes(length);
    }

    public void close() {
        this.byteBuf.release();
    }

    @Generated
    public PostgreSQLPacketPayload(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Generated
    public ByteBuf getByteBuf() {
        return this.byteBuf;
    }
}

