/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.infra.rule.identifier.type.ExportableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DatabaseDiscoveryRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<DatabaseDiscoveryDataSourceRuleConfiguration> data;
    private Map<String, ShardingSphereAlgorithmConfiguration> discoveryTypes;
    private Map<String, String> primaryDataSources;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<DatabaseDiscoveryRuleConfiguration> ruleConfig = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof DatabaseDiscoveryRuleConfiguration).map(each -> (DatabaseDiscoveryRuleConfiguration)each).findAny();
        this.data = ruleConfig.map(optional -> optional.getDataSources().iterator()).orElse(Collections.emptyIterator());
        this.discoveryTypes = ruleConfig.map(DatabaseDiscoveryRuleConfiguration::getDiscoveryTypes).orElse(Collections.emptyMap());
        Optional<ExportableRule> exportableRule = metaData.getRuleMetaData().getRules().stream().filter(each -> each instanceof ExportableRule).map(each -> (ExportableRule)each).findAny();
        this.primaryDataSources = exportableRule.map(optional -> optional.export().get("primary_data_source_key")).orElse(Collections.emptyMap());
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "data_source_names", "primary_data_source_name", "discover_type", "discover_props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        DatabaseDiscoveryDataSourceRuleConfiguration dataSourceRuleConfig = this.data.next();
        String name = dataSourceRuleConfig.getName();
        String primaryDataSourceName = null == this.primaryDataSources.get(name) ? "" : this.primaryDataSources.get(name);
        return Arrays.asList(name, String.join((CharSequence)",", dataSourceRuleConfig.getDataSourceNames()), primaryDataSourceName, this.discoveryTypes.get(dataSourceRuleConfig.getDiscoveryTypeName()).getType(), PropertiesConverter.convert((Properties)this.discoveryTypes.get(dataSourceRuleConfig.getDiscoveryTypeName()).getProps()));
    }

    public String getType() {
        return ShowDatabaseDiscoveryRulesStatement.class.getCanonicalName();
    }
}

