/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.ShowDatabaseDiscoveryHeartbeatsStatement;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DatabaseDiscoveryHeartbeatQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, DatabaseDiscoveryHeartBeatConfiguration>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Collection ruleConfiguration = metaData.getRuleMetaData().findRuleConfiguration(DatabaseDiscoveryRuleConfiguration.class);
        this.data = ruleConfiguration.stream().map(DatabaseDiscoveryRuleConfiguration::getDiscoveryHeartbeats).flatMap(each -> each.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).entrySet().iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, DatabaseDiscoveryHeartBeatConfiguration> entry = this.data.next();
        return Arrays.asList(entry.getKey(), entry.getValue().getProps());
    }

    public String getType() {
        return ShowDatabaseDiscoveryHeartbeatsStatement.class.getName();
    }
}

