/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryTypeSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.CreateDatabaseDiscoveryTypeStatement;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class CreateDatabaseDiscoveryTypeStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDatabaseDiscoveryTypeStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, CreateDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkDuplicateDiscoveryType(schemaName, sqlStatement, currentRuleConfig);
        this.checkInvalidDiscoverType(sqlStatement);
    }

    private void checkDuplicateDiscoveryType(String schemaName, CreateDatabaseDiscoveryTypeStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null == currentRuleConfig) {
            return;
        }
        Set existRuleNames = currentRuleConfig.getDiscoveryTypes().keySet();
        Collection duplicateRuleNames = sqlStatement.getTypes().stream().map(DatabaseDiscoveryTypeSegment::getDiscoveryTypeName).filter(existRuleNames::contains).collect(Collectors.toSet());
        duplicateRuleNames.addAll(this.getToBeCreatedDuplicateRuleNames(sqlStatement));
        DistSQLException.predictionThrow((boolean)duplicateRuleNames.isEmpty(), (DistSQLException)new DuplicateRuleException(RULE_TYPE, schemaName, duplicateRuleNames));
    }

    private Collection<String> getToBeCreatedDuplicateRuleNames(CreateDatabaseDiscoveryTypeStatement sqlStatement) {
        return sqlStatement.getTypes().stream().collect(Collectors.toMap(DatabaseDiscoveryTypeSegment::getDiscoveryTypeName, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private void checkInvalidDiscoverType(CreateDatabaseDiscoveryTypeStatement sqlStatement) throws DistSQLException {
        Collection invalidType = sqlStatement.getTypes().stream().map(each -> each.getAlgorithmSegment().getName()).distinct().filter(each -> !TypedSPIRegistry.findRegisteredService(DatabaseDiscoveryType.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)invalidType.isEmpty(), (DistSQLException)new InvalidAlgorithmConfigurationException(RULE_TYPE, invalidType));
    }

    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateDatabaseDiscoveryTypeStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryType(sqlStatement.getTypes());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryTypes().putAll(toBeCreatedRuleConfig.getDiscoveryTypes());
        }
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return CreateDatabaseDiscoveryTypeStatement.class.getName();
    }

    static {
        ShardingSphereServiceLoader.register(DatabaseDiscoveryType.class);
    }
}

