/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql.type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.shardingsphere.dbdiscovery.mysql.exception.mgr.InvalidMGRGroupNameConfigurationException;
import org.apache.shardingsphere.dbdiscovery.mysql.exception.mgr.InvalidMGRModeException;
import org.apache.shardingsphere.dbdiscovery.mysql.exception.mgr.InvalidMGRPluginException;
import org.apache.shardingsphere.dbdiscovery.mysql.exception.mgr.InvalidMGRReplicationGroupMemberException;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProvider;
import org.apache.shardingsphere.dbdiscovery.spi.ReplicaDataSourceStatus;
import org.apache.shardingsphere.infra.database.metadata.dialect.MySQLDataSourceMetaData;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class MGRMySQLDatabaseDiscoveryProvider
implements DatabaseDiscoveryProvider {
    private static final String QUERY_PLUGIN_STATUS = "SELECT PLUGIN_STATUS FROM information_schema.PLUGINS WHERE PLUGIN_NAME='group_replication'";
    private static final String QUERY_SINGLE_PRIMARY_MODE = "SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_single_primary_mode'";
    private static final String QUERY_GROUP_NAME = "SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_group_name'";
    private static final String QUERY_MEMBER_LIST = "SELECT MEMBER_HOST, MEMBER_PORT, MEMBER_STATE FROM performance_schema.replication_group_members";
    private static final String QUERY_PRIMARY_DATA_SOURCE = "SELECT MEMBER_HOST, MEMBER_PORT FROM performance_schema.replication_group_members WHERE MEMBER_ID = (SELECT VARIABLE_VALUE FROM performance_schema.global_status WHERE VARIABLE_NAME = 'group_replication_primary_member')";
    private static final String QUERY_CURRENT_MEMBER_STATE = "SELECT MEMBER_STATE FROM performance_schema.replication_group_members WHERE MEMBER_HOST=? AND MEMBER_PORT=?";
    private int minEnabledReplicas;
    private String groupName;

    public void init(Properties props) {
        this.minEnabledReplicas = Integer.parseInt(props.getProperty("min-enabled-replicas", "0"));
        this.groupName = props.getProperty("group-name", "");
    }

    public void checkEnvironment(String databaseName, Collection<DataSource> dataSources) {
        ExecutorService executorService = ExecutorEngine.createExecutorEngineWithCPUAndResources((int)dataSources.size()).getExecutorServiceManager().getExecutorService();
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        for (DataSource dataSource : dataSources) {
            futures.add(executorService.submit(() -> this.checkDataSourceEnvironment(databaseName, dataSource)));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Boolean checkDataSourceEnvironment(String databaseName, DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            Boolean bl;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    this.checkPluginActive(databaseName, statement);
                    this.checkSinglePrimaryMode(databaseName, statement);
                    this.checkGroupName(databaseName, statement);
                    this.checkMemberInstanceURL(databaseName, connection.getMetaData().getURL(), statement);
                    bl = Boolean.TRUE;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ignored) {
            return Boolean.FALSE;
        }
    }

    private void checkPluginActive(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_PLUGIN_STATUS);){
            ShardingSpherePreconditions.checkState((resultSet.next() && "ACTIVE".equals(resultSet.getString("PLUGIN_STATUS")) ? 1 : 0) != 0, () -> new InvalidMGRPluginException(databaseName));
        }
    }

    private void checkSinglePrimaryMode(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_SINGLE_PRIMARY_MODE);){
            ShardingSpherePreconditions.checkState((resultSet.next() && "ON".equals(resultSet.getString("VARIABLE_VALUE")) ? 1 : 0) != 0, () -> new InvalidMGRModeException(databaseName));
        }
    }

    private void checkGroupName(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_GROUP_NAME);){
            ShardingSpherePreconditions.checkState((resultSet.next() && this.groupName.equals(resultSet.getString("VARIABLE_VALUE")) ? 1 : 0) != 0, () -> new InvalidMGRGroupNameConfigurationException(this.groupName, databaseName));
        }
    }

    private void checkMemberInstanceURL(String databaseName, String url, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_MEMBER_LIST);){
            while (resultSet.next()) {
                if (!url.contains(String.join((CharSequence)":", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT")))) continue;
                return;
            }
        }
        throw new InvalidMGRReplicationGroupMemberException(url, databaseName);
    }

    public boolean isPrimaryInstance(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(QUERY_PRIMARY_DATA_SOURCE);){
            if (resultSet.next()) {
                MySQLDataSourceMetaData metaData = new MySQLDataSourceMetaData(connection.getMetaData().getURL());
                boolean bl = metaData.getHostname().equals(resultSet.getString("MEMBER_HOST")) && Integer.toString(metaData.getPort()).equals(resultSet.getString("MEMBER_PORT"));
                return bl;
            }
        }
        return false;
    }

    public ReplicaDataSourceStatus loadReplicaStatus(DataSource replicaDataSource) throws SQLException {
        try (Connection connection = replicaDataSource.getConnection();){
            ReplicaDataSourceStatus replicaDataSourceStatus = new ReplicaDataSourceStatus(this.isOnlineDataSource(connection, new MySQLDataSourceMetaData(connection.getMetaData().getURL())), 0L);
            return replicaDataSourceStatus;
        }
    }

    private boolean isOnlineDataSource(Connection connection, MySQLDataSourceMetaData metaData) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(QUERY_CURRENT_MEMBER_STATE);){
            boolean bl;
            block12: {
                preparedStatement.setString(1, metaData.getHostname());
                preparedStatement.setString(2, Integer.toString(metaData.getPort()));
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    boolean bl2 = bl = resultSet.next() && "ONLINE".equals(resultSet.getString("MEMBER_STATE"));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    public Optional<Integer> getMinEnabledReplicas() {
        return Optional.of(this.minEnabledReplicas);
    }

    public String getType() {
        return "MySQL.MGR";
    }
}

