/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.string;

import java.io.Serializable;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLBinaryColumnType;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.MySQLBinlogColumnDef;
import org.apache.shardingsphere.db.protocol.mysql.packet.binlog.row.column.value.MySQLBinlogProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLStringBinlogProtocolValue
implements MySQLBinlogProtocolValue {
    @Override
    public Serializable read(MySQLBinlogColumnDef columnDef, MySQLPacketPayload payload) {
        int type = columnDef.getColumnMeta() >> 8;
        int length = columnDef.getColumnMeta() & 0xFF;
        if ((type & 0x30) != 48) {
            length += (type & 0x30 ^ 0x30) << 4;
            type |= 0x30;
        }
        switch (MySQLBinaryColumnType.valueOf(type)) {
            case MYSQL_TYPE_ENUM: {
                return this.readEnumValue(length, payload);
            }
            case MYSQL_TYPE_SET: {
                return Byte.valueOf(payload.getByteBuf().readByte());
            }
            case MYSQL_TYPE_STRING: {
                return payload.readStringFix(this.readActualLength(length, payload));
            }
        }
        throw new UnsupportedOperationException("");
    }

    private int readActualLength(int length, MySQLPacketPayload payload) {
        if (length < 256) {
            return payload.getByteBuf().readUnsignedByte();
        }
        return payload.getByteBuf().readUnsignedShortLE();
    }

    private Serializable readEnumValue(int meta, MySQLPacketPayload payload) {
        switch (meta) {
            case 1: {
                return Integer.valueOf(payload.readInt1());
            }
            case 2: {
                return Integer.valueOf(payload.readInt2());
            }
        }
        throw new UnsupportedOperationException("MySQL Enum meta in binlog only include value 1 or 2, but actual is " + meta);
    }
}

