/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.binary.execute.protocol.MySQLBinaryProtocolValue;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLTimeBinaryProtocolValue
implements MySQLBinaryProtocolValue {
    @Override
    public Object read(MySQLPacketPayload payload) {
        int length = payload.readInt1();
        payload.readInt1();
        payload.readInt4();
        switch (length) {
            case 0: {
                return new Timestamp(0L);
            }
            case 8: {
                return this.getTimestamp(payload);
            }
            case 12: {
                Timestamp result = this.getTimestamp(payload);
                result.setNanos(payload.readInt4());
                return result;
            }
        }
        throw new IllegalArgumentException(String.format("Wrong length '%d' of MYSQL_TYPE_DATE", length));
    }

    private Timestamp getTimestamp(MySQLPacketPayload payload) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(0, 0, 0, payload.readInt1(), payload.readInt1(), payload.readInt1());
        Timestamp result = new Timestamp(calendar.getTimeInMillis());
        result.setNanos(0);
        return result;
    }

    @Override
    public void write(MySQLPacketPayload payload, Object value) {
        boolean isNanosAbsent;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(((Time)value).getTime());
        int hourOfDay = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        int nanos = new Timestamp(calendar.getTimeInMillis()).getNanos();
        boolean isTimeAbsent = 0 == hourOfDay && 0 == minutes && 0 == seconds;
        boolean bl = isNanosAbsent = 0 == nanos;
        if (isTimeAbsent && isNanosAbsent) {
            payload.writeInt1(0);
            return;
        }
        if (isNanosAbsent) {
            payload.writeInt1(8);
            this.writeTime(payload, hourOfDay, minutes, seconds);
            return;
        }
        payload.writeInt1(12);
        this.writeTime(payload, hourOfDay, minutes, seconds);
        this.writeNanos(payload, nanos);
    }

    private void writeTime(MySQLPacketPayload payload, int hourOfDay, int minutes, int seconds) {
        payload.writeInt1(0);
        payload.writeInt4(0);
        payload.writeInt1(hourOfDay);
        payload.writeInt1(minutes);
        payload.writeInt1(seconds);
    }

    private void writeNanos(MySQLPacketPayload payload, int nanos) {
        payload.writeInt4(nanos);
    }
}

