/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLTextResultSetRowPacket
implements MySQLPacket {
    private static final int NULL = 251;
    private static final DateTimeFormatter DT_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final int sequenceId;
    private final Collection<Object> data;

    public MySQLTextResultSetRowPacket(MySQLPacketPayload payload, int columnCount) {
        this.sequenceId = payload.readInt1();
        this.data = new ArrayList<Object>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            this.data.add(payload.readStringLenenc());
        }
    }

    public void write(MySQLPacketPayload payload) {
        for (Object each : this.data) {
            if (null == each) {
                payload.writeInt1(251);
                continue;
            }
            if (each instanceof byte[]) {
                payload.writeBytesLenenc((byte[])each);
                continue;
            }
            if (each instanceof Timestamp && 0 == ((Timestamp)each).getNanos()) {
                payload.writeStringLenenc(each.toString().split("\\.")[0]);
                continue;
            }
            if (each instanceof BigDecimal) {
                payload.writeStringLenenc(((BigDecimal)each).toPlainString());
                continue;
            }
            if (each instanceof Boolean) {
                byte[] byArray;
                if (((Boolean)each).booleanValue()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                payload.writeBytesLenenc(byArray);
                continue;
            }
            if (each instanceof LocalDateTime) {
                payload.writeStringLenenc(DT_FMT.format((LocalDateTime)each));
                continue;
            }
            payload.writeStringLenenc(each.toString());
        }
    }

    @Generated
    public MySQLTextResultSetRowPacket(int sequenceId, Collection<Object> data) {
        this.sequenceId = sequenceId;
        this.data = data;
    }

    @Override
    @Generated
    public int getSequenceId() {
        return this.sequenceId;
    }

    @Generated
    public Collection<Object> getData() {
        return this.data;
    }
}

