/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.api;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.distsql.parser.core.rule.DistRuleSQLParserFactory;
import org.apache.shardingsphere.distsql.parser.core.standard.DistSQLParserFactory;
import org.apache.shardingsphere.distsql.parser.core.standard.DistSQLVisitor;
import org.apache.shardingsphere.distsql.parser.spi.DistRuleSQLParserFacade;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.parser.ParseASTNode;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DistSQLStatementParserEngine {
    private static final Collection<DistRuleSQLParserFacade> RULE_PARSER_FACADES = new LinkedList<DistRuleSQLParserFacade>();

    public SQLStatement parse(String sql) {
        ParseASTNode parseASTNode;
        try {
            parseASTNode = this.parseFromStandardParser(sql);
        }
        catch (ParseCancellationException ex) {
            parseASTNode = this.parseFromRuleParsers(sql);
        }
        if (parseASTNode.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", new Object[]{sql});
        }
        return (SQLStatement)new DistSQLVisitor().visit(parseASTNode.getRootNode());
    }

    private ParseASTNode parseFromStandardParser(String sql) {
        SQLParser sqlParser = DistSQLParserFactory.newInstance(sql);
        try {
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            throw new SQLParsingException("You have an error in your SQL syntax.");
        }
    }

    private ParseASTNode parseFromRuleParsers(String sql) {
        for (DistRuleSQLParserFacade each : RULE_PARSER_FACADES) {
            try {
                return (ParseASTNode)DistRuleSQLParserFactory.newInstance(sql, each).parse();
            }
            catch (ParseCancellationException parseCancellationException) {
            }
        }
        throw new SQLParsingException("You have an error in your SQL syntax.");
    }

    static {
        for (DistRuleSQLParserFacade each : ServiceLoader.load(DistRuleSQLParserFacade.class)) {
            RULE_PARSER_FACADES.add(each);
        }
    }
}

