/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.core.standard;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.distsql.parser.autogen.DistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.DistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.distsql.parser.segment.FunctionSegment;
import org.apache.shardingsphere.distsql.parser.segment.TableRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.DatabaseDiscoveryRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.EncryptColumnSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.EncryptRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.ReadwriteSplittingRuleSegment;
import org.apache.shardingsphere.distsql.parser.segment.rdl.ShardingBindingTableRuleSegment;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.CheckScalingJobStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.DropScalingJobStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.ResetScalingJobStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.ShowScalingJobListStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.ShowScalingJobStatusStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.StartScalingJobStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.impl.StopScalingJobStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterEncryptRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterShardingBindingTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.impl.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.AddResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateEncryptRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateShardingBindingTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.impl.CreateShardingTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropDatabaseDiscoveryRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropEncryptRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropReadwriteSplittingRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropShardingBindingTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.impl.DropShardingTableRuleStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowResourcesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowDatabaseDiscoveryRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowEncryptRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowReadwriteSplittingRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowShardingBindingTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.impl.ShowShardingTableRulesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class DistSQLVisitor
extends DistSQLStatementBaseVisitor<ASTNode> {
    @Override
    public ASTNode visitAddResource(DistSQLStatementParser.AddResourceContext ctx) {
        LinkedList<DataSourceSegment> connectionInfos = new LinkedList<DataSourceSegment>();
        for (DistSQLStatementParser.DataSourceContext each : ctx.dataSource()) {
            connectionInfos.add((DataSourceSegment)this.visit((ParseTree)each));
        }
        return new AddResourceStatement(connectionInfos);
    }

    @Override
    public ASTNode visitDataSource(DistSQLStatementParser.DataSourceContext ctx) {
        DataSourceSegment result = new DataSourceSegment();
        result.setName(ctx.dataSourceName().getText());
        result.setHostName(ctx.hostName().getText());
        result.setPort(ctx.port().getText());
        result.setDb(ctx.dbName().getText());
        result.setUser(ctx.user().getText());
        result.setPassword(null == ctx.password() ? "" : ctx.password().getText());
        return result;
    }

    @Override
    public ASTNode visitCreateShardingTableRule(DistSQLStatementParser.CreateShardingTableRuleContext ctx) {
        return new CreateShardingTableRuleStatement((Collection)ctx.shardingTableRuleDefinition().stream().map(each -> (TableRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCreateShardingBindingTableRules(DistSQLStatementParser.CreateShardingBindingTableRulesContext ctx) {
        LinkedList<ShardingBindingTableRuleSegment> rules = new LinkedList<ShardingBindingTableRuleSegment>();
        for (DistSQLStatementParser.BindTableRulesDefinitionContext each : ctx.bindTableRulesDefinition()) {
            ShardingBindingTableRuleSegment segment = new ShardingBindingTableRuleSegment();
            segment.setTables(Joiner.on((String)",").join((Iterable)each.tableName().stream().map(t -> new IdentifierValue(t.getText()).getValue()).collect(Collectors.toList())));
            rules.add(segment);
        }
        return new CreateShardingBindingTableRulesStatement(rules);
    }

    @Override
    public ASTNode visitDropResource(DistSQLStatementParser.DropResourceContext ctx) {
        return new DropResourceStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCreateShardingBroadcastTableRules(DistSQLStatementParser.CreateShardingBroadcastTableRulesContext ctx) {
        return new CreateShardingBroadcastTableRulesStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterShardingTableRule(DistSQLStatementParser.AlterShardingTableRuleContext ctx) {
        return new AlterShardingTableRuleStatement((Collection)ctx.shardingTableRuleDefinition().stream().map(each -> (TableRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowShardingBroadcastTableRules(DistSQLStatementParser.ShowShardingBroadcastTableRulesContext ctx) {
        return new ShowShardingBroadcastTableRulesStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitAlterShardingBindingTableRules(DistSQLStatementParser.AlterShardingBindingTableRulesContext ctx) {
        LinkedList<ShardingBindingTableRuleSegment> rules = new LinkedList<ShardingBindingTableRuleSegment>();
        for (DistSQLStatementParser.BindTableRulesDefinitionContext each : ctx.bindTableRulesDefinition()) {
            ShardingBindingTableRuleSegment segment = new ShardingBindingTableRuleSegment();
            segment.setTables(Joiner.on((String)",").join((Iterable)each.tableName().stream().map(t -> new IdentifierValue(t.getText()).getValue()).collect(Collectors.toList())));
            rules.add(segment);
        }
        return new AlterShardingBindingTableRulesStatement(rules);
    }

    @Override
    public ASTNode visitAlterShardingBroadcastTableRules(DistSQLStatementParser.AlterShardingBroadcastTableRulesContext ctx) {
        return new AlterShardingBroadcastTableRulesStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCreateReadwriteSplittingRule(DistSQLStatementParser.CreateReadwriteSplittingRuleContext ctx) {
        return new CreateReadwriteSplittingRuleStatement((Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitReadwriteSplittingRuleDefinition(DistSQLStatementParser.ReadwriteSplittingRuleDefinitionContext ctx) {
        ReadwriteSplittingRuleSegment result = (ReadwriteSplittingRuleSegment)(null != ctx.dynamicReadwriteSplittingRuleDefinition() ? (ASTNode)this.visit((ParseTree)ctx.dynamicReadwriteSplittingRuleDefinition()) : (ASTNode)this.visit((ParseTree)ctx.staticReadwriteSplittingRuleDefinition()));
        Properties props = new Properties();
        if (null != ctx.functionDefinition().algorithmProperties()) {
            ctx.functionDefinition().algorithmProperties().algorithmProperty().forEach(each -> props.setProperty(each.key.getText(), each.value.getText()));
        }
        result.setName(ctx.ruleName().getText());
        result.setLoadBalancer(ctx.functionDefinition().functionName().getText());
        result.setProps(props);
        return result;
    }

    @Override
    public ASTNode visitStaticReadwriteSplittingRuleDefinition(DistSQLStatementParser.StaticReadwriteSplittingRuleDefinitionContext ctx) {
        ReadwriteSplittingRuleSegment result = new ReadwriteSplittingRuleSegment();
        result.setWriteDataSource(ctx.writeResourceName().getText());
        result.setReadDataSources((Collection)ctx.resourceName().stream().map(each -> each.getText()).collect(Collectors.toList()));
        return result;
    }

    @Override
    public ASTNode visitDynamicReadwriteSplittingRuleDefinition(DistSQLStatementParser.DynamicReadwriteSplittingRuleDefinitionContext ctx) {
        ReadwriteSplittingRuleSegment result = new ReadwriteSplittingRuleSegment();
        result.setAutoAwareResource(ctx.IDENTIFIER().getText());
        return result;
    }

    @Override
    public ASTNode visitAlterReadwriteSplittingRule(DistSQLStatementParser.AlterReadwriteSplittingRuleContext ctx) {
        return new AlterReadwriteSplittingRuleStatement((Collection)ctx.readwriteSplittingRuleDefinition().stream().map(each -> (ReadwriteSplittingRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingTableRule(DistSQLStatementParser.DropShardingTableRuleContext ctx) {
        return new DropShardingTableRuleStatement((Collection)ctx.tableName().stream().map(each -> (TableNameSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropShardingBindingTableRules(DistSQLStatementParser.DropShardingBindingTableRulesContext ctx) {
        return new DropShardingBindingTableRulesStatement();
    }

    @Override
    public ASTNode visitDropShardingBroadcastTableRules(DistSQLStatementParser.DropShardingBroadcastTableRulesContext ctx) {
        return new DropShardingBroadcastTableRulesStatement();
    }

    @Override
    public ASTNode visitShardingTableRuleDefinition(DistSQLStatementParser.ShardingTableRuleDefinitionContext ctx) {
        TableRuleSegment result = new TableRuleSegment();
        result.setLogicTable(ctx.tableName().getText());
        LinkedList<String> dataSources = new LinkedList<String>();
        if (null != ctx.resources()) {
            for (TerminalNode each : ctx.resources().IDENTIFIER()) {
                dataSources.add(new IdentifierValue(each.getText()).getValue());
            }
        }
        result.setDataSources(dataSources);
        if (null != ctx.functionDefinition()) {
            result.setTableStrategy((FunctionSegment)this.visit((ParseTree)ctx.functionDefinition()));
            result.setTableStrategyColumn(ctx.shardingColumn().columnName().getText());
        }
        if (null != ctx.keyGenerateStrategy()) {
            result.setKeyGenerateStrategy((FunctionSegment)this.visit((ParseTree)ctx.keyGenerateStrategy().functionDefinition()));
            result.setKeyGenerateStrategyColumn(ctx.keyGenerateStrategy().columnName().getText());
        }
        return result;
    }

    @Override
    public ASTNode visitFunctionDefinition(DistSQLStatementParser.FunctionDefinitionContext ctx) {
        FunctionSegment result = new FunctionSegment();
        result.setAlgorithmName(ctx.functionName().getText());
        Properties algorithmProps = new Properties();
        if (null != ctx.algorithmProperties()) {
            for (DistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperties().algorithmProperty()) {
                algorithmProps.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
            }
        }
        result.setAlgorithmProps(algorithmProps);
        return result;
    }

    @Override
    public ASTNode visitCreateDatabaseDiscoveryRule(DistSQLStatementParser.CreateDatabaseDiscoveryRuleContext ctx) {
        return new CreateDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRuleDefinition().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDatabaseDiscoveryRuleDefinition(DistSQLStatementParser.DatabaseDiscoveryRuleDefinitionContext ctx) {
        DatabaseDiscoveryRuleSegment result = new DatabaseDiscoveryRuleSegment();
        result.setName(ctx.ruleName().getText());
        result.setDataSources((Collection)ctx.resources().IDENTIFIER().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList()));
        result.setDiscoveryTypeName(ctx.functionDefinition().functionName().getText());
        result.setProps(this.buildAlgorithmProperties(ctx.functionDefinition().algorithmProperties()));
        return result;
    }

    @Override
    public ASTNode visitAlterDatabaseDiscoveryRule(DistSQLStatementParser.AlterDatabaseDiscoveryRuleContext ctx) {
        return new AlterDatabaseDiscoveryRuleStatement((Collection)ctx.databaseDiscoveryRuleDefinition().stream().map(each -> (DatabaseDiscoveryRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropDatabaseDiscoveryRule(DistSQLStatementParser.DropDatabaseDiscoveryRuleContext ctx) {
        return new DropDatabaseDiscoveryRuleStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitCreateEncryptRule(DistSQLStatementParser.CreateEncryptRuleContext ctx) {
        return new CreateEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitEncryptRuleDefinition(DistSQLStatementParser.EncryptRuleDefinitionContext ctx) {
        return new EncryptRuleSegment(ctx.tableName().getText(), (Collection)ctx.columnDefinition().stream().map(each -> (EncryptColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitColumnDefinition(DistSQLStatementParser.ColumnDefinitionContext ctx) {
        EncryptColumnSegment result = new EncryptColumnSegment();
        result.setName(ctx.columnName().getText());
        result.setCipherColumn(ctx.cipherColumnName().getText());
        if (Objects.nonNull((Object)ctx.plainColumnName())) {
            result.setPlainColumn(ctx.plainColumnName().getText());
        }
        result.setEncryptor((FunctionSegment)this.visit((ParseTree)ctx.functionDefinition()));
        return result;
    }

    @Override
    public ASTNode visitAlterEncryptRule(DistSQLStatementParser.AlterEncryptRuleContext ctx) {
        return new AlterEncryptRuleStatement((Collection)ctx.encryptRuleDefinition().stream().map(each -> (EncryptRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropEncryptRule(DistSQLStatementParser.DropEncryptRuleContext ctx) {
        return new DropEncryptRuleStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitTableName(DistSQLStatementParser.TableNameContext ctx) {
        return new TableNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitDropReadwriteSplittingRule(DistSQLStatementParser.DropReadwriteSplittingRuleContext ctx) {
        return new DropReadwriteSplittingRuleStatement((Collection)ctx.IDENTIFIER().stream().map(ParseTree::getText).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowResources(DistSQLStatementParser.ShowResourcesContext ctx) {
        return new ShowResourcesStatement(null == ctx.schemaName() ? null : (SchemaSegment)this.visit((ParseTree)ctx.schemaName()));
    }

    @Override
    public ASTNode visitShowShardingBindingTableRules(DistSQLStatementParser.ShowShardingBindingTableRulesContext ctx) {
        return new ShowShardingBindingTableRulesStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitSchemaName(DistSQLStatementParser.SchemaNameContext ctx) {
        return new SchemaSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitShowScalingJobList(DistSQLStatementParser.ShowScalingJobListContext ctx) {
        return new ShowScalingJobListStatement();
    }

    @Override
    public ASTNode visitShowScalingJobStatus(DistSQLStatementParser.ShowScalingJobStatusContext ctx) {
        return new ShowScalingJobStatusStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitStartScalingJob(DistSQLStatementParser.StartScalingJobContext ctx) {
        return new StartScalingJobStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitStopScalingJob(DistSQLStatementParser.StopScalingJobContext ctx) {
        return new StopScalingJobStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitDropScalingJob(DistSQLStatementParser.DropScalingJobContext ctx) {
        return new DropScalingJobStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitShowReadwriteSplittingRules(DistSQLStatementParser.ShowReadwriteSplittingRulesContext ctx) {
        return new ShowReadwriteSplittingRulesStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitShowShardingTableRules(DistSQLStatementParser.ShowShardingTableRulesContext ctx) {
        return new ShowShardingTableRulesStatement(Objects.nonNull((Object)ctx.tableRule()) ? ctx.tableRule().tableName().getText() : null, Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitShowDatabaseDiscoveryRules(DistSQLStatementParser.ShowDatabaseDiscoveryRulesContext ctx) {
        return new ShowDatabaseDiscoveryRulesStatement(Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitShowEncryptRules(DistSQLStatementParser.ShowEncryptRulesContext ctx) {
        return new ShowEncryptRulesStatement(Objects.nonNull((Object)ctx.tableRule()) ? ctx.tableRule().tableName().getText() : null, Objects.nonNull((Object)ctx.schemaName()) ? (SchemaSegment)this.visit((ParseTree)ctx.schemaName()) : null);
    }

    @Override
    public ASTNode visitResetScalingJob(DistSQLStatementParser.ResetScalingJobContext ctx) {
        return new ResetScalingJobStatement(Long.parseLong(ctx.jobId().getText()));
    }

    @Override
    public ASTNode visitCheckScalingJob(DistSQLStatementParser.CheckScalingJobContext ctx) {
        return new CheckScalingJobStatement(Long.parseLong(ctx.jobId().getText()));
    }

    private Properties buildAlgorithmProperties(DistSQLStatementParser.AlgorithmPropertiesContext ctx) {
        Properties result = new Properties();
        for (DistSQLStatementParser.AlgorithmPropertyContext each : ctx.algorithmProperty()) {
            result.setProperty(new IdentifierValue(each.key.getText()).getValue(), new IdentifierValue(each.value.getText()).getValue());
        }
        return result;
    }
}

