/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.factory;

import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;

public final class EncryptAlgorithmFactory {
    public static EncryptAlgorithm newInstance(AlgorithmConfiguration encryptAlgorithmConfig) {
        return (EncryptAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((AlgorithmConfiguration)encryptAlgorithmConfig, EncryptAlgorithm.class);
    }

    public static boolean contains(String encryptAlgorithmType) {
        return TypedSPIRegistry.findRegisteredService(EncryptAlgorithm.class, (String)encryptAlgorithmType).isPresent();
    }

    @Generated
    private EncryptAlgorithmFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(EncryptAlgorithm.class);
    }
}

