/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.swapper.rule.EncryptTableRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.algorithm.YamlShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.swapper.algorithm.ShardingSphereAlgorithmConfigurationYamlSwapper;

public final class EncryptRuleConfigurationYamlSwapper
implements YamlRuleConfigurationSwapper<YamlEncryptRuleConfiguration, EncryptRuleConfiguration> {
    private final EncryptTableRuleConfigurationYamlSwapper tableYamlSwapper = new EncryptTableRuleConfigurationYamlSwapper();
    private final ShardingSphereAlgorithmConfigurationYamlSwapper algorithmSwapper = new ShardingSphereAlgorithmConfigurationYamlSwapper();

    public YamlEncryptRuleConfiguration swapToYamlConfiguration(EncryptRuleConfiguration data) {
        YamlEncryptRuleConfiguration result = new YamlEncryptRuleConfiguration();
        data.getTables().forEach(each -> result.getTables().put(each.getName(), this.tableYamlSwapper.swapToYamlConfiguration((EncryptTableRuleConfiguration)each)));
        data.getEncryptors().forEach((key, value) -> result.getEncryptors().put((String)key, this.algorithmSwapper.swapToYamlConfiguration(value)));
        return result;
    }

    public EncryptRuleConfiguration swapToObject(YamlEncryptRuleConfiguration yamlConfig) {
        return new EncryptRuleConfiguration(this.swapTables(yamlConfig), this.swapEncryptAlgorithm(yamlConfig));
    }

    private Collection<EncryptTableRuleConfiguration> swapTables(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedList<EncryptTableRuleConfiguration> result = new LinkedList<EncryptTableRuleConfiguration>();
        for (Map.Entry<String, YamlEncryptTableRuleConfiguration> entry : yamlConfig.getTables().entrySet()) {
            YamlEncryptTableRuleConfiguration yamlEncryptTableRuleConfig = entry.getValue();
            yamlEncryptTableRuleConfig.setName(entry.getKey());
            result.add(this.tableYamlSwapper.swapToObject(yamlEncryptTableRuleConfig));
        }
        return result;
    }

    private Map<String, ShardingSphereAlgorithmConfiguration> swapEncryptAlgorithm(YamlEncryptRuleConfiguration yamlConfig) {
        LinkedHashMap<String, ShardingSphereAlgorithmConfiguration> result = new LinkedHashMap<String, ShardingSphereAlgorithmConfiguration>(yamlConfig.getEncryptors().size(), 1.0f);
        for (Map.Entry<String, YamlShardingSphereAlgorithmConfiguration> entry : yamlConfig.getEncryptors().entrySet()) {
            result.put(entry.getKey(), this.algorithmSwapper.swapToObject(entry.getValue()));
        }
        return result;
    }

    public Class<EncryptRuleConfiguration> getTypeClass() {
        return EncryptRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "ENCRYPT";
    }

    public int getOrder() {
        return 50;
    }
}

