/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class EncryptRuleQueryResultSet
implements DistSQLResultSet {
    private Iterator<Map.Entry<String, EncryptColumnRuleConfiguration>> data;
    private Map<String, ShardingSphereAlgorithmConfiguration> encryptors;

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<EncryptRuleConfiguration> ruleConfig = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof EncryptRuleConfiguration).map(each -> (EncryptRuleConfiguration)each).findAny();
        this.data = ruleConfig.map(optional -> this.getAllEncryptColumns((EncryptRuleConfiguration)optional, ((ShowEncryptRulesStatement)sqlStatement).getTableName()).entrySet().iterator()).orElse(Collections.emptyIterator());
        this.encryptors = ruleConfig.map(EncryptRuleConfiguration::getEncryptors).orElseGet(Collections::emptyMap);
    }

    private Map<String, EncryptColumnRuleConfiguration> getAllEncryptColumns(EncryptRuleConfiguration encryptRuleConfig, String tableName) {
        HashMap<String, EncryptColumnRuleConfiguration> result = new HashMap<String, EncryptColumnRuleConfiguration>();
        if (Objects.nonNull(tableName)) {
            encryptRuleConfig.getTables().stream().filter(each -> tableName.equalsIgnoreCase(each.getName())).findAny().ifPresent(each -> result.putAll(this.buildEncryptColumnRuleConfigurationMap((EncryptTableRuleConfiguration)each)));
        } else {
            encryptRuleConfig.getTables().forEach(each -> result.putAll(this.buildEncryptColumnRuleConfigurationMap((EncryptTableRuleConfiguration)each)));
        }
        return result;
    }

    private Map<String, EncryptColumnRuleConfiguration> buildEncryptColumnRuleConfigurationMap(EncryptTableRuleConfiguration encryptTableRuleConfig) {
        return encryptTableRuleConfig.getColumns().stream().collect(Collectors.toMap(each -> String.join((CharSequence)".", encryptTableRuleConfig.getName(), each.getLogicColumn()), each -> each));
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table", "logic_column", "cipher_column", "plain_column", "encryptor_type", "encryptor_props");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        Map.Entry<String, EncryptColumnRuleConfiguration> entry = this.data.next();
        return Arrays.asList(entry.getKey().split("\\.")[0], entry.getValue().getLogicColumn(), entry.getValue().getCipherColumn(), entry.getValue().getPlainColumn(), this.encryptors.get(entry.getValue().getEncryptorName()).getType(), PropertiesConverter.convert((Properties)this.encryptors.get(entry.getValue().getEncryptorName()).getProps()));
    }

    public String getType() {
        return ShowEncryptRulesStatement.class.getName();
    }
}

