/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnItemSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;

public final class EncryptRuleStatementConverter {
    public static EncryptRuleConfiguration convert(Collection<EncryptRuleSegment> ruleSegments) {
        LinkedList<EncryptTableRuleConfiguration> tables = new LinkedList<EncryptTableRuleConfiguration>();
        HashMap<String, AlgorithmConfiguration> encryptors = new HashMap<String, AlgorithmConfiguration>();
        for (EncryptRuleSegment each : ruleSegments) {
            tables.add(EncryptRuleStatementConverter.createEncryptTableRuleConfiguration(each));
            encryptors.putAll(EncryptRuleStatementConverter.createEncryptorConfigurations(each));
        }
        return new EncryptRuleConfiguration(tables, encryptors);
    }

    private static EncryptTableRuleConfiguration createEncryptTableRuleConfiguration(EncryptRuleSegment ruleSegment) {
        LinkedList<EncryptColumnRuleConfiguration> columns = new LinkedList<EncryptColumnRuleConfiguration>();
        for (EncryptColumnSegment each : ruleSegment.getColumns()) {
            columns.add(EncryptRuleStatementConverter.createEncryptColumnRuleConfiguration(ruleSegment.getTableName(), each));
        }
        return new EncryptTableRuleConfiguration(ruleSegment.getTableName(), columns);
    }

    private static EncryptColumnRuleConfiguration createEncryptColumnRuleConfiguration(String tableName, EncryptColumnSegment columnSegment) {
        EncryptColumnItemRuleConfiguration cipherColumnConfig = new EncryptColumnItemRuleConfiguration(columnSegment.getCipher().getName(), EncryptRuleStatementConverter.getEncryptorName(tableName, columnSegment.getName()));
        EncryptColumnRuleConfiguration result = new EncryptColumnRuleConfiguration(columnSegment.getName(), cipherColumnConfig);
        if (null != columnSegment.getAssistedQuery()) {
            EncryptRuleStatementConverter.setAssistedQuery(tableName, columnSegment, result);
        }
        if (null != columnSegment.getLikeQuery()) {
            EncryptRuleStatementConverter.setLikeQuery(tableName, columnSegment, result);
        }
        return result;
    }

    private static void setAssistedQuery(String tableName, EncryptColumnSegment columnSegment, EncryptColumnRuleConfiguration result) {
        String assistedQueryEncryptorName = null == columnSegment.getAssistedQuery().getEncryptor() ? null : EncryptRuleStatementConverter.getAssistedQueryEncryptorName(tableName, columnSegment.getName());
        EncryptColumnItemRuleConfiguration assistedQueryColumnConfig = new EncryptColumnItemRuleConfiguration(columnSegment.getAssistedQuery().getName(), assistedQueryEncryptorName);
        result.setAssistedQuery(assistedQueryColumnConfig);
    }

    private static void setLikeQuery(String tableName, EncryptColumnSegment columnSegment, EncryptColumnRuleConfiguration result) {
        String likeQueryEncryptorName = null == columnSegment.getLikeQuery().getEncryptor() ? null : EncryptRuleStatementConverter.getLikeQueryEncryptorName(tableName, columnSegment.getName());
        EncryptColumnItemRuleConfiguration likeQueryColumnConfig = new EncryptColumnItemRuleConfiguration(columnSegment.getLikeQuery().getName(), likeQueryEncryptorName);
        result.setLikeQuery(likeQueryColumnConfig);
    }

    private static Map<String, AlgorithmConfiguration> createEncryptorConfigurations(EncryptRuleSegment ruleSegment) {
        HashMap<String, AlgorithmConfiguration> result = new HashMap<String, AlgorithmConfiguration>(ruleSegment.getColumns().size(), 1.0f);
        for (EncryptColumnSegment each : ruleSegment.getColumns()) {
            result.put(EncryptRuleStatementConverter.getEncryptorName(ruleSegment.getTableName(), each.getName()), EncryptRuleStatementConverter.createEncryptorConfiguration(each.getCipher()));
            if (null != each.getAssistedQuery() && null != each.getAssistedQuery().getEncryptor()) {
                result.put(EncryptRuleStatementConverter.getAssistedQueryEncryptorName(ruleSegment.getTableName(), each.getName()), EncryptRuleStatementConverter.createEncryptorConfiguration(each.getAssistedQuery()));
            }
            if (null == each.getLikeQuery() || null == each.getLikeQuery().getEncryptor()) continue;
            result.put(EncryptRuleStatementConverter.getLikeQueryEncryptorName(ruleSegment.getTableName(), each.getName()), EncryptRuleStatementConverter.createEncryptorConfiguration(each.getLikeQuery()));
        }
        return result;
    }

    private static AlgorithmConfiguration createEncryptorConfiguration(EncryptColumnItemSegment columnSegment) {
        return new AlgorithmConfiguration(columnSegment.getEncryptor().getName(), columnSegment.getEncryptor().getProps());
    }

    private static String getEncryptorName(String tableName, String columnName) {
        return String.format("%s_%s", tableName, columnName);
    }

    private static String getAssistedQueryEncryptorName(String tableName, String columnName) {
        return String.format("assist_%s_%s", tableName, columnName);
    }

    private static String getLikeQueryEncryptorName(String tableName, String columnName) {
        return String.format("like_%s_%s", tableName, columnName);
    }

    @Generated
    private EncryptRuleStatementConverter() {
    }
}

