/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.CountEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class CountEncryptRuleExecutor
implements RQLExecutor<CountEncryptRuleStatement> {
    public Collection<String> getColumnNames() {
        return Arrays.asList("rule_name", "database", "count");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, CountEncryptRuleStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(EncryptRule.class);
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        rule.ifPresent(optional -> this.fillRows((Collection<LocalDataQueryResultRow>)result, (EncryptRule)optional, database.getName()));
        return result;
    }

    private void fillRows(Collection<LocalDataQueryResultRow> result, EncryptRule rule, String databaseName) {
        result.add(new LocalDataQueryResultRow(new Object[]{"encrypt", databaseName, rule.getLogicTableMapper().getTableNames().size()}));
    }

    public Class<CountEncryptRuleStatement> getType() {
        return CountEncryptRuleStatement.class;
    }
}

