/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.query.RQLExecutor;
import org.apache.shardingsphere.encrypt.api.config.CompatibleEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.ShowEncryptRulesStatement;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.props.PropertiesConverter;

public final class ShowEncryptRuleExecutor
implements RQLExecutor<ShowEncryptRulesStatement> {
    public Collection<LocalDataQueryResultRow> getRows(ShardingSphereDatabase database, ShowEncryptRulesStatement sqlStatement) {
        Optional rule = database.getRuleMetaData().findSingleRule(EncryptRule.class);
        Collection<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        if (rule.isPresent()) {
            EncryptRuleConfiguration ruleConfig = ((EncryptRule)rule.get()).getConfiguration() instanceof CompatibleEncryptRuleConfiguration ? ((CompatibleEncryptRuleConfiguration)((EncryptRule)rule.get()).getConfiguration()).convertToEncryptRuleConfiguration() : (EncryptRuleConfiguration)((EncryptRule)rule.get()).getConfiguration();
            result = this.buildData(ruleConfig, sqlStatement);
        }
        return result;
    }

    private Collection<LocalDataQueryResultRow> buildData(EncryptRuleConfiguration ruleConfig, ShowEncryptRulesStatement sqlStatement) {
        return ruleConfig.getTables().stream().filter(each -> null == sqlStatement.getTableName() || each.getName().equals(sqlStatement.getTableName())).map(each -> this.buildColumnData((EncryptTableRuleConfiguration)each, ruleConfig.getEncryptors())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<LocalDataQueryResultRow> buildColumnData(EncryptTableRuleConfiguration tableRuleConfig, Map<String, AlgorithmConfiguration> encryptors) {
        LinkedList<LocalDataQueryResultRow> result = new LinkedList<LocalDataQueryResultRow>();
        for (EncryptColumnRuleConfiguration each : tableRuleConfig.getColumns()) {
            AlgorithmConfiguration encryptorAlgorithmConfig = encryptors.get(each.getCipher().getEncryptorName());
            AlgorithmConfiguration assistedQueryEncryptorAlgorithmConfig = each.getAssistedQuery().isPresent() ? encryptors.get(((EncryptColumnItemRuleConfiguration)each.getAssistedQuery().get()).getEncryptorName()) : null;
            AlgorithmConfiguration likeQueryEncryptorAlgorithmConfig = each.getLikeQuery().isPresent() ? encryptors.get(((EncryptColumnItemRuleConfiguration)each.getLikeQuery().get()).getEncryptorName()) : null;
            result.add(new LocalDataQueryResultRow(Arrays.asList(tableRuleConfig.getName(), each.getName(), each.getCipher().getName(), each.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getName).orElse(""), each.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getName).orElse(""), encryptorAlgorithmConfig.getType(), PropertiesConverter.convert((Properties)encryptorAlgorithmConfig.getProps()), null == assistedQueryEncryptorAlgorithmConfig ? this.nullToEmptyString(null) : assistedQueryEncryptorAlgorithmConfig.getType(), null == assistedQueryEncryptorAlgorithmConfig ? this.nullToEmptyString(null) : PropertiesConverter.convert((Properties)assistedQueryEncryptorAlgorithmConfig.getProps()), null == likeQueryEncryptorAlgorithmConfig ? this.nullToEmptyString(null) : likeQueryEncryptorAlgorithmConfig.getType(), null == likeQueryEncryptorAlgorithmConfig ? this.nullToEmptyString(null) : PropertiesConverter.convert((Properties)likeQueryEncryptorAlgorithmConfig.getProps()))));
        }
        return result;
    }

    private Object nullToEmptyString(Object obj) {
        return null == obj ? "" : obj;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table", "logic_column", "cipher_column", "assisted_query_column", "like_query_column", "encryptor_type", "encryptor_props", "assisted_query_type", "assisted_query_props", "like_query_type", "like_query_props");
    }

    public Class<ShowEncryptRulesStatement> getType() {
        return ShowEncryptRulesStatement.class;
    }
}

