/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptRuleStatementConverter;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.AlterEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class AlterEncryptRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkToBeAlteredRules(databaseName, sqlStatement, currentRuleConfig);
        this.checkColumnNames(sqlStatement);
        this.checkToBeAlteredEncryptors(sqlStatement);
    }

    private void checkCurrentRuleConfiguration(String databaseName, EncryptRuleConfiguration currentRuleConfig) {
        ShardingSpherePreconditions.checkNotNull((Object)currentRuleConfig, () -> new MissingRequiredRuleException("Encrypt", databaseName));
    }

    private void checkToBeAlteredRules(String databaseName, AlterEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        Collection currentEncryptTableNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistEncryptTableNames = this.getToBeAlteredEncryptTableNames(sqlStatement).stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        if (!notExistEncryptTableNames.isEmpty()) {
            throw new MissingRequiredRuleException("Encrypt", databaseName, notExistEncryptTableNames);
        }
    }

    private Collection<String> getToBeAlteredEncryptTableNames(AlterEncryptRuleStatement sqlStatement) {
        return sqlStatement.getRules().stream().map(EncryptRuleSegment::getTableName).collect(Collectors.toList());
    }

    private void checkColumnNames(AlterEncryptRuleStatement sqlStatement) {
        for (EncryptRuleSegment each : sqlStatement.getRules()) {
            ShardingSpherePreconditions.checkState((boolean)this.isColumnNameNotConflicts(each), () -> new InvalidRuleConfigurationException("encrypt", "assisted query column or like query column conflicts with logic column"));
        }
    }

    private boolean isColumnNameNotConflicts(EncryptRuleSegment rule) {
        return rule.getColumns().stream().noneMatch(each -> null != each.getLikeQuery() && each.getName().equals(each.getLikeQuery().getName()) || null != each.getAssistedQuery() && each.getName().equals(each.getAssistedQuery().getName()));
    }

    private void checkToBeAlteredEncryptors(AlterEncryptRuleStatement sqlStatement) {
        LinkedHashSet encryptors = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> each.getColumns().forEach(column -> {
            encryptors.add(column.getCipher().getEncryptor());
            if (null != column.getAssistedQuery()) {
                encryptors.add(column.getAssistedQuery().getEncryptor());
            }
            if (null != column.getLikeQuery()) {
                encryptors.add(column.getLikeQuery().getEncryptor());
            }
        }));
        encryptors.stream().filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    public EncryptRuleConfiguration buildToBeAlteredRuleConfiguration(AlterEncryptRuleStatement sqlStatement) {
        return EncryptRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        this.dropRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        this.addRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
        this.dropUnusedEncryptor(currentRuleConfig);
    }

    private void dropRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        for (EncryptTableRuleConfiguration each : toBeAlteredRuleConfig.getTables()) {
            Optional<EncryptTableRuleConfiguration> toBeRemovedTableRuleConfig = currentRuleConfig.getTables().stream().filter(tableRule -> tableRule.getName().equals(each.getName())).findAny();
            Preconditions.checkState((boolean)toBeRemovedTableRuleConfig.isPresent());
            currentRuleConfig.getTables().remove(toBeRemovedTableRuleConfig.get());
        }
    }

    private void addRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeAlteredRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeAlteredRuleConfig.getTables());
        currentRuleConfig.getEncryptors().putAll(toBeAlteredRuleConfig.getEncryptors());
    }

    private void dropUnusedEncryptor(EncryptRuleConfiguration currentRuleConfig) {
        Collection inUsedEncryptors = currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getCipher().getEncryptorName()).collect(Collectors.toSet());
        inUsedEncryptors.addAll(currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("")).collect(Collectors.toSet()));
        inUsedEncryptors.addAll(currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("")).collect(Collectors.toSet()));
        Collection unusedEncryptors = currentRuleConfig.getEncryptors().keySet().stream().filter(each -> !inUsedEncryptors.contains(each)).collect(Collectors.toSet());
        unusedEncryptors.forEach(each -> currentRuleConfig.getEncryptors().remove(each));
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public Class<AlterEncryptRuleStatement> getType() {
        return AlterEncryptRuleStatement.class;
    }
}

