/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.algorithm.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.distsql.handler.exception.rule.InvalidRuleConfigurationException;
import org.apache.shardingsphere.distsql.handler.exception.storageunit.EmptyStorageUnitException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.encrypt.assisted.AssistedEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.like.LikeEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.api.encrypt.standard.StandardEncryptAlgorithm;
import org.apache.shardingsphere.encrypt.distsql.handler.converter.EncryptRuleStatementConverter;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptColumnItemSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.segment.EncryptRuleSegment;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.CreateEncryptRuleStatement;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;

public final class CreateEncryptRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        if (!sqlStatement.isIfNotExists()) {
            this.checkDuplicateRuleNames(database.getName(), sqlStatement, currentRuleConfig);
        }
        this.checkColumnNames(sqlStatement);
        this.checkAlgorithmTypes(sqlStatement);
        this.checkToBeCreatedEncryptors(sqlStatement);
        this.checkDataSources(database);
    }

    private void checkAlgorithmTypes(CreateEncryptRuleStatement sqlStatement) {
        sqlStatement.getRules().stream().flatMap(each -> each.getColumns().stream()).forEach(each -> {
            this.checkAlgorithmType(each.getCipher(), "standard encrypt", StandardEncryptAlgorithm.class);
            this.checkAlgorithmType(each.getLikeQuery(), "like encrypt", LikeEncryptAlgorithm.class);
            this.checkAlgorithmType(each.getAssistedQuery(), "assisted encrypt", AssistedEncryptAlgorithm.class);
        });
    }

    private void checkAlgorithmType(EncryptColumnItemSegment itemSegment, String algorithmType, Class<?> encryptAlgorithmClass) {
        if (null == itemSegment || null == itemSegment.getEncryptor()) {
            return;
        }
        EncryptAlgorithm encryptAlgorithm = (EncryptAlgorithm)TypedSPILoader.getService(EncryptAlgorithm.class, (Object)itemSegment.getEncryptor().getName(), (Properties)itemSegment.getEncryptor().getProps());
        ShardingSpherePreconditions.checkState((boolean)encryptAlgorithmClass.isInstance(encryptAlgorithm), () -> new InvalidAlgorithmConfigurationException(algorithmType, encryptAlgorithm.getType()));
    }

    private void checkDuplicateRuleNames(String databaseName, CreateEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement, currentRuleConfig);
        ShardingSpherePreconditions.checkState((boolean)duplicatedRuleNames.isEmpty(), () -> new DuplicateRuleException("encrypt", databaseName, duplicatedRuleNames));
    }

    private Collection<String> getDuplicatedRuleNames(CreateEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        Collection currentRuleNames = new LinkedHashSet();
        if (null != currentRuleConfig) {
            currentRuleNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toSet());
        }
        return sqlStatement.getRules().stream().map(EncryptRuleSegment::getTableName).filter(currentRuleNames::contains).collect(Collectors.toSet());
    }

    private void checkColumnNames(CreateEncryptRuleStatement sqlStatement) {
        for (EncryptRuleSegment each : sqlStatement.getRules()) {
            ShardingSpherePreconditions.checkState((boolean)this.isColumnNameNotConflicts(each), () -> new InvalidRuleConfigurationException("encrypt", "assisted query column or like query column conflicts with logic column"));
        }
    }

    private boolean isColumnNameNotConflicts(EncryptRuleSegment rule) {
        return rule.getColumns().stream().noneMatch(each -> null != each.getLikeQuery() && each.getName().equals(each.getLikeQuery().getName()) || null != each.getAssistedQuery() && each.getName().equals(each.getAssistedQuery().getName()));
    }

    private void checkToBeCreatedEncryptors(CreateEncryptRuleStatement sqlStatement) {
        LinkedHashSet encryptors = new LinkedHashSet();
        sqlStatement.getRules().forEach(each -> each.getColumns().forEach(column -> {
            encryptors.add(column.getCipher().getEncryptor());
            if (null != column.getAssistedQuery()) {
                encryptors.add(column.getAssistedQuery().getEncryptor());
            }
            if (null != column.getLikeQuery()) {
                encryptors.add(column.getLikeQuery().getEncryptor());
            }
        }));
        encryptors.stream().filter(Objects::nonNull).forEach(each -> TypedSPILoader.checkService(EncryptAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    private void checkDataSources(ShardingSphereDatabase database) {
        ShardingSpherePreconditions.checkState((!database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().isEmpty() ? 1 : 0) != 0, () -> new EmptyStorageUnitException(database.getName()));
    }

    public EncryptRuleConfiguration buildToBeCreatedRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, CreateEncryptRuleStatement sqlStatement) {
        Collection segments = sqlStatement.getRules();
        if (sqlStatement.isIfNotExists()) {
            Collection<String> duplicatedRuleNames = this.getDuplicatedRuleNames(sqlStatement, currentRuleConfig);
            segments.removeIf(each -> duplicatedRuleNames.contains(each.getTableName()));
        }
        return EncryptRuleStatementConverter.convert(segments);
    }

    public void updateCurrentRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, EncryptRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.getTables().addAll(toBeCreatedRuleConfig.getTables());
        currentRuleConfig.getEncryptors().putAll(toBeCreatedRuleConfig.getEncryptors());
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public Class<CreateEncryptRuleStatement> getType() {
        return CreateEncryptRuleStatement.class;
    }
}

