/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.distsql.handler.update;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.handler.exception.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.distsql.handler.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnItemRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.distsql.parser.statement.DropEncryptRuleStatement;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;

public final class DropEncryptRuleStatementUpdater
implements RuleDefinitionDropUpdater<DropEncryptRuleStatement, EncryptRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        this.checkToBeDroppedEncryptTableNames(database.getName(), sqlStatement, currentRuleConfig);
    }

    private void checkToBeDroppedEncryptTableNames(String databaseName, DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        if (sqlStatement.isIfExists()) {
            return;
        }
        ShardingSpherePreconditions.checkState((boolean)this.isExistRuleConfig((RuleConfiguration)currentRuleConfig), () -> new MissingRequiredRuleException("Encrypt", databaseName));
        Collection currentEncryptTableNames = currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toList());
        Collection notExistedTableNames = sqlStatement.getTables().stream().filter(each -> !currentEncryptTableNames.contains(each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedTableNames.isEmpty(), () -> new MissingRequiredRuleException("Encrypt", databaseName, notExistedTableNames));
    }

    public boolean hasAnyOneToBeDropped(DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && !this.getIdenticalData(currentRuleConfig.getTables().stream().map(EncryptTableRuleConfiguration::getName).collect(Collectors.toSet()), sqlStatement.getTables()).isEmpty();
    }

    public EncryptRuleConfiguration buildToBeDroppedRuleConfiguration(EncryptRuleConfiguration currentRuleConfig, DropEncryptRuleStatement sqlStatement) {
        LinkedList<EncryptTableRuleConfiguration> toBeDroppedTables = new LinkedList<EncryptTableRuleConfiguration>();
        HashMap toBeDroppedEncryptors = new HashMap();
        for (String each2 : sqlStatement.getTables()) {
            toBeDroppedTables.add(new EncryptTableRuleConfiguration(each2, Collections.emptyList()));
            this.dropRule(currentRuleConfig, each2);
        }
        DropEncryptRuleStatementUpdater.findUnusedEncryptors(currentRuleConfig).forEach(each -> toBeDroppedEncryptors.put(each, (AlgorithmConfiguration)currentRuleConfig.getEncryptors().get(each)));
        return new EncryptRuleConfiguration(toBeDroppedTables, toBeDroppedEncryptors);
    }

    public boolean updateCurrentRuleConfiguration(DropEncryptRuleStatement sqlStatement, EncryptRuleConfiguration currentRuleConfig) {
        sqlStatement.getTables().forEach(each -> this.dropRule(currentRuleConfig, (String)each));
        this.dropUnusedEncryptor(currentRuleConfig);
        return currentRuleConfig.isEmpty();
    }

    private void dropRule(EncryptRuleConfiguration currentRuleConfig, String ruleName) {
        Optional<EncryptTableRuleConfiguration> encryptTableRuleConfig = currentRuleConfig.getTables().stream().filter(each -> each.getName().equals(ruleName)).findAny();
        encryptTableRuleConfig.ifPresent(optional -> currentRuleConfig.getTables().remove(encryptTableRuleConfig.get()));
    }

    private void dropUnusedEncryptor(EncryptRuleConfiguration currentRuleConfig) {
        DropEncryptRuleStatementUpdater.findUnusedEncryptors(currentRuleConfig).forEach(each -> currentRuleConfig.getEncryptors().remove(each));
    }

    private static Collection<String> findUnusedEncryptors(EncryptRuleConfiguration currentRuleConfig) {
        Collection inUsedEncryptors = currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getCipher().getEncryptorName()).collect(Collectors.toSet());
        inUsedEncryptors.addAll(currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getAssistedQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("")).collect(Collectors.toSet()));
        inUsedEncryptors.addAll(currentRuleConfig.getTables().stream().flatMap(each -> each.getColumns().stream()).map(optional -> optional.getLikeQuery().map(EncryptColumnItemRuleConfiguration::getEncryptorName).orElse("")).collect(Collectors.toSet()));
        return currentRuleConfig.getEncryptors().keySet().stream().filter(each -> !inUsedEncryptors.contains(each)).collect(Collectors.toSet());
    }

    public Class<EncryptRuleConfiguration> getRuleConfigurationClass() {
        return EncryptRuleConfiguration.class;
    }

    public Class<DropEncryptRuleStatement> getType() {
        return DropEncryptRuleStatement.class;
    }
}

